package com.clx.performance.vo.pc.linewarn;

import com.clx.performance.enums.OrderGoodsStatusEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class LineWarnTraceVO {

    @Schema(description = "货单编号", example = "10000")
    private String orderGoodsNo;

    @Schema(description = "发货地址id", example = "1")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "北京")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "山西")
    private String receiveAddress;

    @Schema(description="发货地址经度")
    private BigDecimal sendLongitude;
    @Schema(description="发货地址纬度")
    private BigDecimal sendLatitude;
    @Schema(description="收货地址经度")
    private BigDecimal receiveLongitude;
    @Schema(description="收货地址纬度")
    private BigDecimal receiveLatitude;

    @Schema(description="货单状态")
    private Integer orderGoodsStatus;
    @Schema(description="货单状态")
    private String orderGoodsStatusMsg;
    public String getOrderGoodsStatusMsg() {
        return OrderGoodsStatusEnum.Status.getMsgByCode(orderGoodsStatus);
    }
    @Schema(description="货单吨数")
    private BigDecimal extractWeight;
    @Schema(description="装车吨数")
    private BigDecimal loadWeight;
    @Schema(description="卸车吨数")
    private BigDecimal unloadWeight;

    @Schema(description="车辆列表")
    private List<LineWarnTruckTraceInfoVO> truckList;

    @Schema(description="推荐线路")
    private LineWarnRouteVO route;

}
