package com.clx.performance.vo.app;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.math.RoundingMode;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildFreightInfoVO {

    @Schema(description = "货物id", example = "1")
    private Integer goodsId;
    @Schema(description = "货物名称", example = "煤")
    private String goodsName;
    @Schema(description = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @Schema(description = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @Schema(description = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @Schema(description = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @Schema(description = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @Schema(description = "拉运重量（单位吨）", example = "1.23")
    private BigDecimal weight;
    @Schema(description = "运费（元）（实际运费）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;
    @Schema(description = "损耗单价(分)", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossPrice;

    @Schema(description = "总运费（元）", example = "1.23")
    private BigDecimal totalFreight;
    public BigDecimal getTotalFreight() {
        BigDecimal totalFreight = freightPrice.multiply(weight);
        if (unloadNet != null){
            totalFreight = freightPrice.multiply(unloadNet.compareTo(loadNet) < 0? unloadNet : loadNet);
            BigDecimal dif = unloadNet.subtract(weight);
            if (dif.compareTo(BigDecimal.ZERO) < 0){
                totalFreight = totalFreight.add(lossPrice.multiply(dif));
            }
        }
        return totalFreight.setScale(2, RoundingMode.HALF_UP);
    }

    @Schema(description = "亏吨扣款（元）", example = "1.23")
    private BigDecimal lossFreight;
    public BigDecimal getLossFreight() {
        return (loadNet==null || unloadNet==null || unloadNet.compareTo(loadNet)>0)? BigDecimal.ZERO : lossPrice.multiply(loadNet.subtract(unloadNet)).setScale(2, RoundingMode.HALF_UP);
    }

    @Schema(description = "状态", example = "0")
    private Integer status;

}