package com.clx.performance.param.pc.carrier;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class CarrierPageCollectTruckWaitParam extends PageParam {
    @Schema(description = "司机姓名", example = "")
    private String name;
    @Schema(description = "联系方式", example = "")
    private String mobile;
    @Schema(description = "车牌号", example = "")
    private String truckNo;

    @Schema(description = "运单编号", example = "")
    private String childNo;
    @Schema(description = "排队地点", example = "")
    private String address;
    @Schema(description = "排队类型：1 货源地排队 2目的地排队", example = "")
    private Integer reportType;
    @Schema(description = "是否排队：1 无需排队 2 场内需要排队 3 厂外需要排队", example = "")
    private Integer waitType;

    @Schema(description = "上报开始时间")
    private String beginTime;
    @Schema(description = "上报结束时间")
    private String endTime;
    @Schema(description = "审核状态：0待审核 1已审核")
    private Integer auditStatus;

}
