package com.clx.performance.param.mq.linewarn;

import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import lombok.*;

import java.util.Arrays;
import java.util.Optional;

/**
 * @Author: aiqingguo
 * @Description: 通知
 * @Date: 2023-10-19 15:45:25
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class LineWarnLineReportMqParam {

    private Integer sendSystemAddressId;
    private Integer receiveSystemAddressId;
    private Integer reportType;
    private Integer estimatedTravelTime;    //预计通行时间

    @Getter
    @AllArgsConstructor
    public enum ReportType {
        LINE(1, "线路异常"),
        JAM(2, "拥堵预警"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<ReportType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(ReportType::getMsg).orElse(null);
        }
    }

}
