package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 装车范围校验检查参数
 */
@Getter
@Setter
@NoArgsConstructor
public class OrderChildLoadRangeCheckParam {

    @Schema(description = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description="纬度")
    private BigDecimal latitude;

    @Schema(description="经度")
    private BigDecimal longitude;

}
