package com.clx.performance.enums;

import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InternalMessageTemplateEnum {

    //自定义业务类型code


    //待办-待报价订单  ========================================================================

    //待报价
    public static final Integer CUSTOM_WAIT_QUOTATION_CODE = 10100;
    //拒绝报价code
    public static final Integer CUSTOM_QUOTATION_REJECT_CODE = 10101;

    //待办-待审核事项 ===========================================================================
    //待审核：司机驾驶认证
    public static final Integer CUSTOM_WAIT_AUDIT_LICENCE_CODE = 10200;
    //待审核：司机车辆认证
    public static final Integer CUSTOM_WAIT_AUDIT_TRUCK_AUTH_CODE = 10201;
    //已承接订单
    public static final Integer CUSTOM_PLATFORM_UNDERTAKING_CODE = 10203;
    //货主违约通知
    public static final Integer CUSTOM_OWNER_TRIGGER_BREAK_CONTRACT_CODE = 10204;
    //司机违约通知
    public static final Integer CUSTOM_DRIVER_TRIGGER_BREAK_CONTRACT_CODE = 10205;
    //收到减吨申请
    public static final Integer CUSTOM_RECEIVE_SUB_WEIGHT_APPLY_CODE = 10206;
    //收到延期申请
    public static final Integer CUSTOM_RECEIVE_DELAY_APPLY_CODE = 10207;
    //货主同意减吨申请
    public static final Integer CUSTOM_AGREE_SUB_WEIGHT_APPLY_CODE = 10208;
    //货主拒绝减吨申请
    public static final Integer CUSTOM_REJECT_SUB_WEIGHT_APPLY_CODE = 10209;
    //货主同意延期申请
    public static final Integer CUSTOM_AGREE_DELAY_APPLY_CODE = 10210;
    //货主拒绝延期申请
    public static final Integer CUSTOM_REJECT_DELAY_APPLY_CODE = 10211;

    //货主已确认报价
    public static final Integer CUSTOM_CONFIRMED_QUOTATION_CODE = 10212;


    //待办-待创建货单 ===================================================================
    //货单待创建
    public static final Integer CUSTOM_WAIT_CREATE_ORDER_GOODS_CODE = 10300;
    //货主同意调价申请
    public static final Integer CUSTOM_OWNER_AGREE_UNDERTAKING_ORDER_ADJUSTMENT_PRICE_CODE = 10301;

    //通知-订单通知 ===================================================================
    //货主同意调价申请
    public static final Integer CUSTOM_OWNER_AGREE_POST_ORDER_ORDER_ADJUSTMENT_PRICE_CODE = 10400;
    //货主拒绝调价申请
    public static final Integer CUSTOM_OWNER_REJECT_UNDERTAKING_ORDER_ADJUSTMENT_PRICE_CODE = 10401;
    //货主已取消订单
    public static final Integer CUSTOM_OWNER_CANCEL_ORDER_CODE = 10402;





    //上报-司机上报 ======================================================================

    //待审核：司机货源地信息上报
    public static final Integer CUSTOM_DRIVER_REPORT_SEND_INFO_CODE = 10500;
    //待审核：司机异常情况上报
    public static final Integer CUSTOM_DRIVER_REPORT_EXCEPTION_SITUATION_CODE = 10501;
    //待审核：无接单上报
    public static final Integer CUSTOM_DRIVER_REPORT_NO_TAKE_ORDER_CODE = 10502;
    //待审核：交通情况上报
    public static final Integer CUSTOM_DRIVER_REPORT_TRAFFIC_SITUATION_CODE = 10503;
    //待审核：煤炭质量上报
    public static final Integer CUSTOM_DRIVER_REPORT_COAL_QUALITY_CODE = 10504;
    //待审核：排队信息上报
    public static final Integer CUSTOM_DRIVER_REPORT_LINE_UP_INFO_CODE = 10505;
    //司机上报：位置
    public static final Integer CUSTOM_DRIVER_REPORT_POSITION_CODE = 10506;
    //司机上报：油表信息
    public static final Integer CUSTOM_DRIVER_REPORT_REFUEL_CODE = 10507;
    //司机上报：其他
    public static final Integer CUSTOM_DRIVER_REPORT_OTHER_CODE = 10508;




    //上报-内部上报 ======================================================================

    //内部上报：线路信息
    public static final Integer CUSTOM_INTERNAL_REPORT_ROUTE_CODE = 10600;
    //内部上报：车流量
    public static final Integer CUSTOM_INTERNAL_REPORT_TRAFFIC_VOLUME_CODE = 10601;
    //内部上报：厂区规则
    public static final Integer CUSTOM_INTERNAL_REPORT_SITE_RULES_CODE = 10602;
    //内部上报：调度异常
    public static final Integer CUSTOM_INTERNAL_REPORT_SCHEDULING_EXCEPTION_CODE = 10603;
    //内部上报：位置坐标
    public static final Integer CUSTOM_INTERNAL_REPORT_COORDINATE_POSITION_CODE = 10604;



    //通知-投诉通知 ======================================================================
    //客户投诉
    public static final Integer CUSTOM_DRIVER_SUBMIT_COMPLAINT_CODE = 10700;






    //运单预警map
    public static Map<Integer,String> CHILD_WARN_MAP = new HashMap<>();
    //线路预警map
    public static Map<Integer,String> LINE_WARN_MAP = new HashMap<>();
    //待报价订单map
    public static Map<Integer,String> WAIT_QUOTATION_ORDER_MAP = new HashMap<>();
    //待审核事项map
    public static Map<Integer,String> WAIT_APPROVED_ITEM_MAP = new HashMap<>();

    //待创建货单map
    public static Map<Integer,String> WAIT_CREATE_ORDER_GOODS_MAP = new HashMap<>();
    //订单通知map
    public static Map<Integer,String> ORDER_NOTICE_MAP = new HashMap<>();
    //投诉通知map
    public static Map<Integer,String> COMPLAINT_NOTICE_MAP = new HashMap<>();
    //司机上报map
    public static Map<Integer,String> DRIVER_REPORT_MAP = new HashMap<>();
    //内部上报map
    public static Map<Integer,String> INTERNAL_REPORT_MAP = new HashMap<>();








    //key:businessType  value: key:具体实际业务类型的code， value:BusinessTypeDetail的code
    public static Map<String, Map<Integer,String>> businessTypeMap = new HashMap<>();
    static {

        //预警-运单预警
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.ARRIVE_SEND_DELAY.getCode(),BusinessTypeDetail.ARRIVE_SEND_DELAY.getCode());
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.GOTO_SEND_TIMEOUT.getCode(),BusinessTypeDetail.GOTO_SEND_TIMEOUT.getCode());
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.ARRIVE_RECEIVE_DELAY.getCode(),BusinessTypeDetail.ARRIVE_SEND_DELAY.getCode());
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.GOTO_RECEIVE_TIMEOUT.getCode(),BusinessTypeDetail.ARRIVE_SEND_DELAY.getCode());
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.PARK_TIMEOUT.getCode(),BusinessTypeDetail.ARRIVE_SEND_DELAY.getCode());
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.LOAD_TIMEOUT.getCode(),BusinessTypeDetail.ARRIVE_SEND_DELAY.getCode());
        CHILD_WARN_MAP.put(VehicleWarnConfigEnum.WarnType.UNLOAD_TIMEOUT.getCode(),BusinessTypeDetail.ARRIVE_SEND_DELAY.getCode());


        //预警-线路预警
        LINE_WARN_MAP.put(LineWarnConfigEnum.WarnType.TAKE.getCode(),BusinessTypeDetail.TAKE.getCode());
        LINE_WARN_MAP.put(LineWarnConfigEnum.WarnType.UNLOAD.getCode(),BusinessTypeDetail.UNLOAD.getCode());
        LINE_WARN_MAP.put(LineWarnConfigEnum.WarnType.CONGESTION.getCode(),BusinessTypeDetail.CONGESTION.getCode());
        LINE_WARN_MAP.put(LineWarnConfigEnum.WarnType.WEATHER.getCode(),BusinessTypeDetail.WEATHER.getCode());
        LINE_WARN_MAP.put(LineWarnConfigEnum.WarnType.CHILD_ABNORMAL.getCode(),BusinessTypeDetail.CHILD_ABNORMAL.getCode());
        LINE_WARN_MAP.put(LineWarnConfigEnum.WarnType.LINE_ABNORMAL.getCode(),BusinessTypeDetail.LINE_ABNORMAL.getCode());



        //待办-待报价订单
        WAIT_QUOTATION_ORDER_MAP.put(CUSTOM_WAIT_QUOTATION_CODE,BusinessTypeDetail.WAIT_QUOTATION.getCode());
        WAIT_QUOTATION_ORDER_MAP.put(CUSTOM_QUOTATION_REJECT_CODE,BusinessTypeDetail.QUOTATION_REJECT.getCode());

        //待办-待办待审核事项
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_WAIT_AUDIT_LICENCE_CODE,BusinessTypeDetail.WAIT_AUDIT_LICENCE_AUTH.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_WAIT_AUDIT_TRUCK_AUTH_CODE,BusinessTypeDetail.WAIT_AUDIT_TRUCK_AUTH.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_PLATFORM_UNDERTAKING_CODE,BusinessTypeDetail.PLATFORM_UNDERTAKING.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_OWNER_TRIGGER_BREAK_CONTRACT_CODE,BusinessTypeDetail.OWNER_TRIGGER_BREAK_CONTRACT.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_DRIVER_TRIGGER_BREAK_CONTRACT_CODE,BusinessTypeDetail.DRIVER_TRIGGER_BREAK_CONTRACT.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_RECEIVE_SUB_WEIGHT_APPLY_CODE,BusinessTypeDetail.RECEIVE_SUB_WEIGHT_APPLY.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_RECEIVE_DELAY_APPLY_CODE,BusinessTypeDetail.RECEIVE_DELAY_APPLY.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_AGREE_SUB_WEIGHT_APPLY_CODE,BusinessTypeDetail.AGREE_SUB_WEIGHT_APPLY.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_REJECT_SUB_WEIGHT_APPLY_CODE,BusinessTypeDetail.REJECT_SUB_WEIGHT_APPLY.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_AGREE_DELAY_APPLY_CODE,BusinessTypeDetail.AGREE_DELAY_APPLY.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_REJECT_DELAY_APPLY_CODE,BusinessTypeDetail.REJECT_DELAY_APPLY.getCode());
        WAIT_APPROVED_ITEM_MAP.put(CUSTOM_CONFIRMED_QUOTATION_CODE,BusinessTypeDetail.CONFIRMED_QUOTATION.getCode());



        //代办-待创建货单
        WAIT_CREATE_ORDER_GOODS_MAP.put(CUSTOM_WAIT_CREATE_ORDER_GOODS_CODE,BusinessTypeDetail.WAIT_CREATE_ORDER_GOODS.getCode());
        WAIT_CREATE_ORDER_GOODS_MAP.put(CUSTOM_OWNER_AGREE_UNDERTAKING_ORDER_ADJUSTMENT_PRICE_CODE,BusinessTypeDetail.OWNER_AGREE_UNDERTAKING_ORDER_ADJUSTMENT_PRICE.getCode());


        //通知-订单通知
        ORDER_NOTICE_MAP.put(CUSTOM_OWNER_AGREE_POST_ORDER_ORDER_ADJUSTMENT_PRICE_CODE,BusinessTypeDetail.OWNER_AGREE_POST_ORDER_ORDER_ADJUSTMENT_PRICE.getCode());
        ORDER_NOTICE_MAP.put(CUSTOM_OWNER_REJECT_UNDERTAKING_ORDER_ADJUSTMENT_PRICE_CODE,BusinessTypeDetail.OWNER_REJECT_UNDERTAKING_ORDER_ADJUSTMENT_PRICE.getCode());
        ORDER_NOTICE_MAP.put(CUSTOM_OWNER_CANCEL_ORDER_CODE,BusinessTypeDetail.OWNER_CANCEL_ORDER.getCode());


        //通知-投诉通知
        COMPLAINT_NOTICE_MAP.put(CUSTOM_DRIVER_SUBMIT_COMPLAINT_CODE,BusinessTypeDetail.DRIVER_SUBMIT_COMPLAINT.getCode());


        //上报-司机上报
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_SEND_INFO_CODE,BusinessTypeDetail.DRIVER_REPORT_SEND_INFO.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_EXCEPTION_SITUATION_CODE,BusinessTypeDetail.DRIVER_REPORT_EXCEPTION_SITUATION.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_NO_TAKE_ORDER_CODE,BusinessTypeDetail.DRIVER_REPORT_NO_TAKE_ORDER.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_TRAFFIC_SITUATION_CODE,BusinessTypeDetail.DRIVER_REPORT_TRAFFIC_SITUATION.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_COAL_QUALITY_CODE,BusinessTypeDetail.DRIVER_REPORT_COAL_QUALITY.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_LINE_UP_INFO_CODE,BusinessTypeDetail.DRIVER_REPORT_LINE_UP_INFO.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_POSITION_CODE,BusinessTypeDetail.DRIVER_REPORT_POSITION.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_REFUEL_CODE,BusinessTypeDetail.DRIVER_REPORT_REFUEL.getCode());
        DRIVER_REPORT_MAP.put(CUSTOM_DRIVER_REPORT_OTHER_CODE,BusinessTypeDetail.DRIVER_REPORT_OTHER.getCode());



        //上报-内部上报
        INTERNAL_REPORT_MAP.put(CUSTOM_INTERNAL_REPORT_ROUTE_CODE,BusinessTypeDetail.INTERNAL_REPORT_ROUTE.getCode());
        INTERNAL_REPORT_MAP.put(CUSTOM_INTERNAL_REPORT_TRAFFIC_VOLUME_CODE,BusinessTypeDetail.INTERNAL_REPORT_TRAFFIC_VOLUME.getCode());
        INTERNAL_REPORT_MAP.put(CUSTOM_INTERNAL_REPORT_SITE_RULES_CODE,BusinessTypeDetail.INTERNAL_REPORT_SITE_RULES.getCode());
        INTERNAL_REPORT_MAP.put(CUSTOM_INTERNAL_REPORT_SCHEDULING_EXCEPTION_CODE,BusinessTypeDetail.INTERNAL_REPORT_SCHEDULING_EXCEPTION.getCode());
        INTERNAL_REPORT_MAP.put(CUSTOM_INTERNAL_REPORT_COORDINATE_POSITION_CODE,BusinessTypeDetail.INTERNAL_REPORT_COORDINATE_POSITION.getCode());




        businessTypeMap.put(BusinessType.CHILD_WARN.getCode(),CHILD_WARN_MAP);
        businessTypeMap.put(BusinessType.LINE_WARN.getCode(),LINE_WARN_MAP);
        businessTypeMap.put(BusinessType.WAIT_QUOTATION_ORDER.getCode(),WAIT_QUOTATION_ORDER_MAP);
        businessTypeMap.put(BusinessType.WAIT_APPROVED_ITEM.getCode(),WAIT_APPROVED_ITEM_MAP);
        businessTypeMap.put(BusinessType.WAIT_CREATE_ORDER_GOODS.getCode(),WAIT_CREATE_ORDER_GOODS_MAP);
        businessTypeMap.put(BusinessType.ORDER_NOTICE.getCode(),ORDER_NOTICE_MAP);
        businessTypeMap.put(BusinessType.COMPLAINT_NOTICE.getCode(),COMPLAINT_NOTICE_MAP);
        businessTypeMap.put(BusinessType.DRIVER_REPORT.getCode(),DRIVER_REPORT_MAP);
        businessTypeMap.put(BusinessType.INTERNAL_REPORT.getCode(),INTERNAL_REPORT_MAP);
    }





    @Getter
    @AllArgsConstructor
    public enum TemplateType {
        ARRIVE_SEND_DELAY(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.ARRIVE_SEND_DELAY),
        GOTO_SEND_TIMEOUT(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.GOTO_SEND_TIMEOUT),
        ARRIVE_RECEIVE_DELAY(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.ARRIVE_RECEIVE_DELAY),
        GOTO_RECEIVE_TIMEOUT(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.GOTO_RECEIVE_TIMEOUT),
        PARK_TIMEOUT(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.PARK_TIMEOUT),
        LOAD_TIMEOUT(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.LOAD_TIMEOUT),
        UNLOAD_TIMEOUT(PlatformType.CARRIER, MessageType.WARN, BusinessType.CHILD_WARN,BusinessTypeDetail.UNLOAD_TIMEOUT),
        ;
        private final PlatformType platform;      //承运平台  司机APP
        private final MessageType messageType;   //预警、待办、通知、上报
        private final BusinessType businessType;   //业务大类   运单预警
        private final BusinessTypeDetail businessDetailType;  //业务详细分类   前往目的地超时等


        public static Optional<TemplateType> getByBusinessTypeDetailCode(String businessTypeDetailCode) {
            return Arrays.stream(values()).filter(e -> e.businessDetailType.code.equals(businessTypeDetailCode)).findFirst();
        }


    }



    @Getter
    @AllArgsConstructor
    public enum BusinessTypeDetail {

        //预警-运单预警
        ARRIVE_SEND_DELAY("ARRIVE_SEND_DELAY", "预警通知：到达货源地延误","运单%s,到达货源地延误，请尽快处理。","",""),
        GOTO_SEND_TIMEOUT("GO_TO_SEND_TIMEOUT", "预警通知：前往货源地超时","运单%s,前往货源地超时，请尽快处理。","",""),
        ARRIVE_RECEIVE_DELAY("ARRIVE_RECEIVE_DELAY", "预警通知：到达目的地延误","运单%s,到达目的地延误，请尽快处理。","",""),
        GOTO_RECEIVE_TIMEOUT("GOTO_RECEIVE_TIMEOUT", "预警通知：前往目的地超时","运单%s,到达目的地超时，请尽快处理。","",""),
        PARK_TIMEOUT("PARK_TIMEOUT", "预警通知：前往货源地超时","运单%s,停留超时，请尽快处理。","",""),
        LOAD_TIMEOUT("LOAD_TIMEOUT", "预警通知：前往货源地超时","运单%s,装车超时，请尽快处理。","",""),
        UNLOAD_TIMEOUT("UNLOAD_TIMEOUT", "预警通知：前往货源地超时","运单%s,卸车超时，请尽快处理。","",""),

        //预警-线路预警
        TAKE("TAKE", "预警通知：接单预警","货单【%s】，触发接单预警，请尽快处理。","",""),
        UNLOAD("UNLOAD", "预警通知：卸车预警","货单【%s】，触发卸车预警，请尽快处理。","",""),
        CONGESTION("CONGESTION", "预警通知：拥堵预警","货单【%s】，触发拥堵，请尽快处理。","",""),
        WEATHER("WEATHER", "预警通知：天气预警","货单【%s】，触发天气预警，请尽快处理。","",""),
        CHILD_ABNORMAL("CHILD_ABNORMAL", "预警通知：运单异常","货单【%s】，触发运单预警，请尽快处理。","",""),
        LINE_ABNORMAL("LINE_ABNORMAL", "预警通知：线路异常","货单【%s】，触发线路预警，请尽快处理。","",""),


        //待办-待报价订单
        WAIT_QUOTATION("WAIT_QUOTATION", "订单待报价","您收到了一条货主的订单，请尽快进行报价。","",""),
        QUOTATION_REJECT("QUOTATION_REJECT", "报价驳回：重新报价","您的订单【%s】报价已被驳回，请重新报价。","",""),

        //待办-待审核事项
        WAIT_AUDIT_LICENCE_AUTH("WAIT_AUDIT_LICENCE", "待审核：司机驾驶认证","您有一个司机认证待审核，请及时处理。","",""),
        WAIT_AUDIT_TRUCK_AUTH("WAIT_AUDIT_TRUCK_AUTH", "待审核：司机车辆认证","您有一个车辆认证待审核，请及时处理。","",""),
        CONFIRMED_QUOTATION("CONFIRMED_QUOTATION", "已同意报价","【%s】货主已同意报价。","",""),
        PLATFORM_UNDERTAKING("PLATFORM_UNDERTAKING", "已承接订单","【%s】货主已同意报价，平台已承接。","",""),
        OWNER_TRIGGER_BREAK_CONTRACT("OWNER_TRIGGER_BREAK_CONTRACT", "货主违约通知","您收到一条货主违约信息，违约编号【%s】","",""),
        DRIVER_TRIGGER_BREAK_CONTRACT("DRIVER_TRIGGER_BREAK_CONTRACT", "司机违约通知","您收到一条司机违约信息，违约编号【%s】","",""),
        RECEIVE_SUB_WEIGHT_APPLY("RECEIVE_SUB_WEIGHT_APPLY", "收到减吨申请","您收到一条司机违约信息，违约编号【%s】","",""),
        RECEIVE_DELAY_APPLY("RECEIVE_DELAY_APPLY", "收到延期申请","您收到一条延期申请，订单编号【%s】。","",""),
        AGREE_SUB_WEIGHT_APPLY("AGREE_SUB_WEIGHT_APPLY", "货主同意减吨申请","货主已同意您的减吨申请，订单编号【%s】。","",""),
        REJECT_SUB_WEIGHT_APPLY("REJECT_SUB_WEIGHT_APPLY", "货主拒绝减吨申请","货主已拒绝您的减吨申请，订单编号【%s】。","",""),
        AGREE_DELAY_APPLY("AGREE_DELAY_APPLY", "货主同意延期申请","货主已同意您的延期申请，订单编号【%s】。","",""),
        REJECT_DELAY_APPLY("REJECT_DELAY_APPLY", "货主拒绝延期申请","货主已拒绝您的延期申请，订单编号【%s】。","",""),

        //代办-待创建货单
        WAIT_CREATE_ORDER_GOODS("WAIT_CREATE_ORDER_GOODS", "货单待创建","【%s】货主已同意报价，请及时创建货单。","",""),
        OWNER_AGREE_UNDERTAKING_ORDER_ADJUSTMENT_PRICE("OWNER_AGREE_UNDERTAKING_ORDER_ADJUSTMENT_PRICE", "货主同意调价申请","货主已同意您的调价申请，【%s】。","",""),//已承接订单


        //通知-订单通知
        OWNER_AGREE_POST_ORDER_ORDER_ADJUSTMENT_PRICE("OWNER_AGREE_POST_ORDER_ORDER_ADJUSTMENT_PRICE", "货主同意调价申请","货主已同意您的调价申请，【%s】。","",""),//已挂单订单
        OWNER_REJECT_UNDERTAKING_ORDER_ADJUSTMENT_PRICE("OWNER_REJECT_UNDERTAKING_ORDER_ADJUSTMENT_PRICE", "货主拒绝调价申请","货主已拒绝您的调价申请，订单编号【】。","",""),//已承接订单
        OWNER_CANCEL_ORDER("OWNER_CANCEL_ORDER", "货主已取消订单","货主已取消订单，订单编号【%s】。","",""),
        //通知-投诉通知
        DRIVER_SUBMIT_COMPLAINT("DRIVER_SUBMIT_COMPLAINT","客户投诉","您收到了一条客户投诉，运单编号【%s】，投诉类型【%s】，投诉内容【%s】。","",""),


        //上报-司机上报、
        DRIVER_REPORT_SEND_INFO("DRIVER_REPORT_SEND_INFO","待审核：司机货源地信息上报","【%s】上报了一条货源地信息，请前往处理审核。","",""),
        DRIVER_REPORT_EXCEPTION_SITUATION("DRIVER_REPORT_EXCEPTION_SITUATION","待审核：司机异常情况上报","【%s】上报了一条异常信息，异常类型【】，异常原因【】请前往处理审核。","",""),
        DRIVER_REPORT_NO_TAKE_ORDER("DRIVER_REPORT_NO_TAKE_ORDER","待审核：无接单上报","【%s】上报了一条无接单信息，无接单原因【】，请前往处理审核。","",""),
        DRIVER_REPORT_TRAFFIC_SITUATION("DRIVER_REPORT_TRAFFIC_SITUATION","待审核：交通情况上报","【%s】上报了一条交通信息，请前往处理审核。","",""),
        DRIVER_REPORT_COAL_QUALITY("DRIVER_REPORT_COAL_QUALITY","待审核：煤炭质量上报","【%s】上报了一条煤炭质量信息，请前往处理审核。","",""),
        DRIVER_REPORT_LINE_UP_INFO("DRIVER_REPORT_LINE_UP_INFO","待审核：排队信息上报","【%s】上报了一条排队信息，请前往处理审核。","",""),
        DRIVER_REPORT_POSITION("DRIVER_REPORT_POSITION","司机上报：位置","【%s】上报了一条位置信息【%s】。","",""),
        DRIVER_REPORT_REFUEL("DRIVER_REPORT_REFUEL","司机上报：油表信息","【%s】上报了一条油表信息。","",""),
        DRIVER_REPORT_OTHER("DRIVER_REPORT_OTHER","司机上报：其他","【%s】上报了一条其他信息，内容为：【%s】。","",""),


        //上报-内部上报
        INTERNAL_REPORT_ROUTE("INTERNAL_REPORT_ROUTE","内部上报：线路信息","【%s】上报了一条线路信息，请点击查看。","",""),
        INTERNAL_REPORT_TRAFFIC_VOLUME("INTERNAL_REPORT_TRAFFIC_VOLUME","内部上报：车流量","【%s】上报了一条车流量信息，请点击查看。","",""),
        INTERNAL_REPORT_SITE_RULES("INTERNAL_REPORT_SITE_RULES","内部上报：厂区规则","【%s】上报了一条厂区规定,规定内容【%s】，请点击查看。","",""),
        INTERNAL_REPORT_SCHEDULING_EXCEPTION("INTERNAL_REPORT_SCHEDULING_EXCEPTION","内部上报：调度异常","【%s】上报了一条调度异常,异常情况【%s】，异常内容【%s】，请点击查看。","",""),
        INTERNAL_REPORT_COORDINATE_POSITION("INTERNAL_REPORT_COORDINATE_POSITION","内部上报：位置坐标","【%s】上报了一条位置坐标,请点击查看。","",""),

        ;

        private final String code;
        private final String title;
        private final String content;
        private final String jumpUrl;
        private final String paramJson;


        public static Optional<BusinessTypeDetail> getByCode(String code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
        public static String getTitle(String code) {
            if (code == null) {return null;}
            return getByCode(code).map(BusinessTypeDetail::getTitle).orElse(null);
        }
    }


    @Getter
    @AllArgsConstructor
    public enum BusinessType {
        CHILD_WARN("CHILD_WARN", "运单预警"),
        LINE_WARN("LINE_WARN", "线路预警"),
        WAIT_QUOTATION_ORDER("WAIT_QUOTATION_ORDER", "待报价订单"),
        WAIT_APPROVED_ITEM("WAIT_APPROVED_ITEM", "待审核事项"),
        WAIT_CREATE_ORDER_GOODS("WAIT_CREATE_ORDER_GOODS", "待创建货单"),
        ORDER_NOTICE("ORDER_NOTICE", "订单通知"),
        COMPLAINT_NOTICE("COMPLAINT_NOTICE", "投诉通知"),
        DRIVER_REPORT("DRIVER_REPORT", "司机上报"),
        INTERNAL_REPORT("INTERNAL_REPORT", "内部上报"),

        ;

        private final String code;
        private final String name;
        public static Optional<BusinessType> getByCode(String code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getName(String code) {
            if (code == null) {return null;}
            return getByCode(code).map(BusinessType::getName).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum PlatformType {
        CARRIER("carrier-platform-npc", "承运平台"),
        DRIVER_APP("carrier-driver-app", "司机APP"),

        ;

        private final String code;
        private final String name;



        public static Optional<PlatformType> getByCode(String code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getName(String code) {
            if (code == null) {return null;}
            return getByCode(code).map(PlatformType::getName).orElse(null);
        }
    }




    //预警、待办、通知、上报
    @Getter
    @AllArgsConstructor
    public enum MessageType {
        WARN("WARN", "预警"),
        WAIT_DEAL("WAIT_DEAL", "待办"),
        NOTICE("NOTICE", "通知"),
        REPORT("REPORT", "上报"),

        ;

        private final String code;
        private final String name;



        public static Optional<MessageType> getByCode(String  code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getName(String  code) {
            if (code == null) {return null;}
            return getByCode(code).map(MessageType::getName).orElse(null);
        }
    }











}
