package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum BreakContractRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum TriggerType {
        SYSTEM(1, "系统触发"),
        MANUAL(2, "手动触发"),
        EXCEPTION_REPORT(3, "异常上报"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<TriggerType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(BreakContractRecordEnum.TriggerType::getMsg).orElse(null);
        }

    }
    @Getter
    @AllArgsConstructor
    public enum BreakContractPartyType {
        PLATFORM(1, "平台"),
        OWNER(2, "货主"),
        DRIVER(3, "司机"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<BreakContractPartyType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(BreakContractRecordEnum.BreakContractPartyType::getMsg).orElse(null);
        }


    }

    @Getter
    @AllArgsConstructor
    public enum ReadFlag {
        NO(0, "未读"),
        YES(1, "已读"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<ReadFlag> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
    }

}
