package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum AppEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum UniqueIdentifier {

        LMS_MANAGE(1, "物流子系统-lms-manage"),
        PURCHASE_MANAGE(2, "供应链-purchase-manage"),
        LMS_SMART_WEIGHT(3, "LMS-smart-weight")

        ;

        private final Integer code;
        private final String name;

        public static Optional<UniqueIdentifier> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(UniqueIdentifier::getName).orElse(null);
        }
    }


}
