package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.param.mq.InternalMessageParam;
import com.clx.performance.service.SendInternalMessageService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
@AllArgsConstructor
public class SendCarrierInternalMessageListener {

    private final SendInternalMessageService sendInternalMessageService;


    @RabbitListener(queues = RabbitKeyConstants.SEND_CARRIER_INTERNAL_MESSAGE_QUEUE)
    public void onMessage(Message message) {
        try{
            log.info("监听到承运发送站内信开始，消息内容{}", new String(message.getBody()));
            InternalMessageParam data = JSON.parseObject(new String(message.getBody()),
                    new TypeReference<MqWrapper<InternalMessageParam>>() {
                    }).getData();

            sendInternalMessageService.sendCarrierInternalMessage(data);
        }catch (Exception e){
            log.info("监听到承运发送站内信发生异常，异常原因：{}", ExceptionUtils.getStackTrace(e));
        }
    }
}
