package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.data.OrderChildData;
import com.clx.performance.dto.zjxl.dts.DataTransportDTO;
import com.clx.performance.enums.DtsOperationTypeEnum;
import com.clx.performance.enums.OrderChildEnum;
import com.msl.common.utils.DtsMapConvertUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Slf4j
@Component
public class OrderChildDtsListener  {


    //@RabbitListener(queues = RabbitKeyConstants.CLX_PERFORMANCE_ORDER_CHILD_QUEUE)
    public void onMessage(Message message) {
        try {
            String msg = new String(message.getBody());
            log.info("DTS消息同步开始, database:clx_performance.order_child, msg:{}", msg);

            DataTransportDTO dataTransportDTO = JSON.parseObject(msg, DataTransportDTO.class);

            OrderChildData before = DtsMapConvertUtil.convert(dataTransportDTO.getBeforeMap(), new OrderChildData());
            OrderChildData after = DtsMapConvertUtil.convert(dataTransportDTO.getAfterMap(), new OrderChildData());

            if(Objects.equals(DtsOperationTypeEnum.INSERT.getCode(),dataTransportDTO.getOperationType().getCode())){
                //同步after数据
                System.out.println("新增:"+after);
            }else if(Objects.equals(DtsOperationTypeEnum.UPDATE.getCode(),dataTransportDTO.getOperationType().getCode())){
                if(OrderChildEnum.SYNC_STATUS_lIST.contains(after.getStatus()) && !Objects.equals(before.getStatus(),after.getStatus())){
                    //同步after数据
                    System.out.println("修改:"+after);
                }
            }else if(Objects.equals(DtsOperationTypeEnum.UPDATE.getCode(),dataTransportDTO.getOperationType().getCode())){
                //数据删除
                System.out.println("删除:"+before);
            }


        } catch (Exception e) {
            log.info("DTS消息同步失败, database:clx_performance.order_child, error:{}", e.getMessage());
        }
    }

}
