package com.clx.performance.feign;

import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

@FeignClient(name = "clx-performance")
public interface PerformanceFeign {

    /**
     * 通过货单号获取定向车辆
     *
     * @param orderGoodsNo
     * @return
     */
    @GetMapping(value = {"clx-performance/feign/orderGoodsDriverTruck/getTrucksByOrderGoodsNo"})
    Result<List<Integer>> getTrucksByOrderGoodsNo(@RequestParam("orderGoodsNo") @NotBlank(message = "货单编号不可为空") String orderGoodsNo);

    @GetMapping(value = {"clx-performance/feign/orderChild/getOrderChildTotalByUserNo"})
    Integer getOrderChildTotalByUserNo(@RequestParam("userNo") Long userNo);

    @GetMapping(value = {"clx-performance/feign/orderGoods/getOrderGoodsListByOrderNo"})
    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(@RequestParam String orderNo);

}
