package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@Getter
@AllArgsConstructor
@SuppressWarnings("all")
public enum DriverTruckEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum TruckType {
        TRACTOR(1, "牵引车"),
        NOT_TRACTOR(2, "非牵引车");
        private final Integer code;
        private final String msg;

        public static Optional<TruckType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }


    @Getter
    @AllArgsConstructor
    public enum ExpiredStatus {
        NOT_EXPIRED(0, "未过期"),
        TO_BE_EXPIRED(1, "即将过期"),
        EXPIRED(2, "已过期");
        private final Integer code;
        private final String msg;

        public static Optional<ExpiredStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum AuditStatus {
        AUDIT(0, "待审核"),
        APPROVED(1, "审核通过"),
        REVIEW_REJECTION(2, "审核驳回"),
        EXPIRED(3, "已过期"),

        TO_BE_EXPIRED(4, "即将过期");      //前端使用，非数据库状态

        private final Integer code;
        private final String msg;

        public static Optional<AuditStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum CarOwner {
        DRIVER(0, "司机"),
        CAR_OWNER(1, "车主");

        private final Integer code;
        private final String msg;

        public static Optional<CarOwner> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum TruckOrderStatus {
        EMPTY(1, "空车"),
        ORDER_EMPTY(2, "运单空车"),
        ORDER_HEAVY(3, "运单重车");

        private final Integer code;
        private final String msg;

        public static Optional<TruckOrderStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }
}
