package com.clx.performance.service.impl.trace;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyTraceConstants;
import com.clx.performance.param.mq.trace.TruckTraceSyncMqParam;
import com.clx.performance.service.trace.TruckTraceMqService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class TruckTraceMqServiceImpl implements TruckTraceMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void truckTracSync(String childNo, String truckNo, String beginTime, String endTime) {
        TruckTraceSyncMqParam mq = new TruckTraceSyncMqParam();
        mq.setChildNo(childNo);
        mq.setTruckNo(truckNo);
        mq.setBeginTime(beginTime);
        mq.setEndTime(endTime);

        MqDelay delay = new MqDelay<>(RabbitKeyTraceConstants.DEFAULT_EXCHANGE, RabbitKeyTraceConstants.TRUCK_TRACE_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyTraceConstants.DEFAULT_EXCHANGE, RabbitKeyTraceConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }
}
