package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.sqlProvider.OrderGoodsSqlProvider;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsMapper extends BaseMapper<OrderGoods> {

    @Update(" update order_goods set " +
            " residue_transport_weight = residue_transport_weight-#{weight} " +
            " where id = #{orderId}")
    int updateWeight(@Param("orderId") Integer orderId, @Param("weight") BigDecimal weight);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getMaxOrderGoodsId")
    String getMaxOrderGoodsId(String type);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "pageOrderGoodsList")
    IPage<OrderGoodsVO> pageOrderGoodsList(Page<OrderGoodsVO> page, PageOrderGoodsListParam param);

    @Update(" update order_goods set " +
            " residue_transport_weight = residue_transport_weight-#{weight}," +
            " already_transport_weight = already_transport_weight+#{weight}," +
            "order_goods_status = #{orderGoodsStatus}" +
            " where id = #{id}")
    void updateOrderGoodsWeightAndStatus(@Param("id") Integer id, @Param("weight") BigDecimal orderChildWeight, @Param("orderGoodsStatus") Integer orderGoodsStatus);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "openOrderPageGoodsList")
    IPage<OrderGoodsAPPVO> openOrderPageGoodsList(Page<OrderGoodsAPPVO> page);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "exclusiveOrderPageGoodsList")
    IPage<OrderGoodsAPPVO> exclusiveOrderPageGoodsList(Page<OrderGoodsAPPVO> page, List<String> param);
}
