package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderChildLogDao;
import com.clx.performance.enums.OrderChildLogEnum;
import com.clx.performance.mapper.OrderChildLogMapper;
import com.clx.performance.model.OrderChildLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 运单图片
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildLogDaoImpl extends BaseDaoImpl<OrderChildLogMapper, OrderChildLog, Integer> implements OrderChildLogDao {
    @Override
    public List<OrderChildLog> getOrderChildNodeLog(String childNo) {
        return list(lQrWrapper().eq(OrderChildLog::getChildNo,childNo).notIn(OrderChildLog::getType, OrderChildLogEnum.Type.PAY.getCode()
                , OrderChildLogEnum.Type.RELOAD.getCode(), OrderChildLogEnum.Type.REUNLOAD.getCode()
                , OrderChildLogEnum.Type.SETTLEMENT.getCode(), OrderChildLogEnum.Type.POUND_AUDIT.getCode()
                , OrderChildLogEnum.Type.POUND_AUDIT_REJECT.getCode(), OrderChildLogEnum.Type.COMPLETE.getCode()
                , OrderChildLogEnum.Type.RELOAD_AND_REUNLOAD.getCode()).groupBy(OrderChildLog::getType));
    }
}
