package com.clx.performance.controller.temp;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.listener.OrderChildSyncTransportListener;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.settle.SettlementMqService;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/settlement")
public class TempSettlementController {
    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private SettlementMqService settlementMqService;
    @Autowired
    private OrderChildSyncTransportListener orderChildSyncTransportListener;


    @ApiOperation(value = "运单同步broker", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/orderChildSync", method = RequestMethod.GET)
    public Result orderChildSync(String childNo) {
        OrderChild orderChild = orderChildDao.getByChildNo(childNo).get();

        // 同步broker
        orderChildSyncTransportListener.transportOrderChildProcess(orderChild);

        return Result.ok();
    }

    @ApiOperation(value = "开票类型同步", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/invoiceTypeSync", method = RequestMethod.GET)
    public Result invoiceTypeSync(String childNo) {

        settlementMqService.invoiceTypeSync(childNo);

        return Result.ok();
    }

    @ApiOperation(value = "开票状态同步", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/invoiceStatusSync", method = RequestMethod.GET)
    public Result invoiceStatusSync(String childNo) {

        settlementMqService.invoiceStatusSync(childNo);

        return Result.ok();
    }
    @ApiOperation(value = "支付状态同步", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/payStatusSync", method = RequestMethod.GET)
    public Result payStatusSync(String childNo) {

        settlementMqService.payStatusSync(childNo);

        return Result.ok();
    }

}
