/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.signers;

import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DSA;
import cn.com.infosec.crypto.params.ECKeyParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.math.ec.ECAlgorithms;
import cn.com.infosec.math.ec.ECConstants;
import cn.com.infosec.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECDSASigner
implements ECConstants,
DSA {
    ECKeyParameters key;
    SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d;
        BigInteger k;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = n.bitLength();
            while ((k = new BigInteger(nBitLength, this.random)).equals(ZERO) || (r = (x = (p = this.key.getParameters().getG().multiply(k)).getX().toBigInteger()).mod(n)).equals(ZERO)) {
            }
            d = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s = k.modInverse(n).multiply(e.add(d.multiply(r))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q, u2);
        BigInteger v = point.getX().toBigInteger().mod(n);
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() > message.length * 8) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }
}

