/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.icao;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.icao.DataGroupHash;
import cn.com.infosec.asn1.icao.ICAOObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class LDSSecurityObject
extends ASN1Encodable
implements ICAOObjectIdentifiers {
    public static final int ub_DataGroups = 16;
    DERInteger version = new DERInteger(0);
    AlgorithmIdentifier digestAlgorithmIdentifier;
    DataGroupHash[] datagroupHash;

    public static LDSSecurityObject getInstance(Object obj) {
        if (obj == null || obj instanceof LDSSecurityObject) {
            return (LDSSecurityObject)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new LDSSecurityObject(ASN1Sequence.getInstance(obj));
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public LDSSecurityObject(ASN1Sequence seq) {
        if (seq == null || seq.size() == 0) {
            throw new IllegalArgumentException("null or empty sequence passed.");
        }
        Enumeration e = seq.getObjects();
        this.version = DERInteger.getInstance(e.nextElement());
        this.digestAlgorithmIdentifier = AlgorithmIdentifier.getInstance(e.nextElement());
        ASN1Sequence datagroupHashSeq = ASN1Sequence.getInstance(e.nextElement());
        this.checkDatagroupHashSeqSize(datagroupHashSeq.size());
        this.datagroupHash = new DataGroupHash[datagroupHashSeq.size()];
        int i = 0;
        while (i < datagroupHashSeq.size()) {
            this.datagroupHash[i] = DataGroupHash.getInstance(datagroupHashSeq.getObjectAt(i));
            ++i;
        }
    }

    public LDSSecurityObject(AlgorithmIdentifier digestAlgorithmIdentifier, DataGroupHash[] datagroupHash) {
        this.digestAlgorithmIdentifier = digestAlgorithmIdentifier;
        this.datagroupHash = datagroupHash;
        this.checkDatagroupHashSeqSize(datagroupHash.length);
    }

    private void checkDatagroupHashSeqSize(int size) {
        if (size < 2 || size > 16) {
            throw new IllegalArgumentException("wrong size in DataGroupHashValues : not in (2..16)");
        }
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.digestAlgorithmIdentifier;
    }

    public DataGroupHash[] getDatagroupHash() {
        return this.datagroupHash;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        seq.add(this.version);
        seq.add(this.digestAlgorithmIdentifier);
        ASN1EncodableVector seqname = new ASN1EncodableVector();
        int i = 0;
        while (i < this.datagroupHash.length) {
            seqname.add(this.datagroupHash[i]);
            ++i;
        }
        seq.add(new DERSequence(seqname));
        return new DERSequence(seq);
    }
}

