package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerRepaymentParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerRepaymentOfOwner;
import com.clx.performance.service.loan.OwnerRepaymentService;
import com.clx.performance.vo.pc.loan.carrier.OwnerRepaymentVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerRepayment")
@Validated
@Api(tags = "承运端-借款管理")
@AllArgsConstructor
public class CarrierOwnerRepaymentController {

    private final OwnerRepaymentService ownerRepaymentService;


    @ApiOperation(value = "还款列表",notes = "<br>By:刘海泉")
    @PostMapping("/pageOwnerRepayment")
    @UnitCovert(param = false)
    public Result<PageData<OwnerRepaymentVO>> pageOwnerRepayment(@RequestBody @Validated PageCarrierOwnerRepaymentParam param) {
        IPage<OwnerRepaymentVO> page  = ownerRepaymentService.pageOwnerRepayment(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "分页搜索货主还款列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageOwnerRepaymentOfOwner")
    @UnitCovert(param = false)
    public Result<PageData<OwnerRepaymentVO>> pageOwnerRepaymentOfOwner(@RequestBody @Validated PageOwnerRepaymentOfOwner param) {
        IPage<OwnerRepaymentVO> page = ownerRepaymentService.pageOwnerRepaymentOfOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "逾期且未还款的记录",notes = "<br>By:jiwngwenye")
    @GetMapping("/ownerRepaymentOverdueList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerRepaymentVO>> ownerRepaymentOverdueList() {
        IPage<OwnerRepaymentVO> page  = ownerRepaymentService.ownerRepaymentOverdueList();
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "核销",notes = "<br>By:姜文业")
    @GetMapping("/adjust")
    public Result<Object> adjust(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        ownerRepaymentService.adjust(id);
        return Result.ok();
    }


}
