package com.clx.performance.controller.feign;

import com.clx.performance.param.feign.CancelOrderGoodsParam;
import com.clx.performance.param.feign.DistributionTruckParam;
import com.clx.performance.param.pc.OrderChildReportParam;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.vo.feign.FreightEstimateVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/feign/orderGoods")
@Validated
@Api(tags = "货单Feign")
@AllArgsConstructor
public class OrderGoodsFeignController {

    private final OrderGoodsService orderGoodsService;

    @GetMapping({"/getOrderGoodsListByOrderNo"})
    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(@RequestParam("userNo") @NotNull(message = "订单编号不可为空") String orderNo) {
        return orderGoodsService.getOrderGoodsListByOrderNo(orderNo);
    }

    @GetMapping({"/updateOrderGoodsStopFlag"})
    Result<Boolean> updateOrderGoodsStopFlag(@RequestParam("orderNo") @NotBlank(message = "订单编号不可为空") String orderNo,
                                             @RequestParam("stopFlag") @NotNull(message = "暂停标志不可为空") Integer stopFlag) {
        return Result.ok(orderGoodsService.updateOrderGoodsStopFlag(orderNo,stopFlag));
    }

    @GetMapping({"/updateSystemAddressId"})
    Result<Boolean> updateSystemAddressId(@RequestParam("ownerAddressId") @NotNull(message = "货主地址id不能为空") Integer ownerAddressId,
                                             @RequestParam("systemAddressId") @NotNull(message = "系统地址id不能为空") Integer systemAddressId) {
        return Result.ok(orderGoodsService.updateSystemAddressId(ownerAddressId,systemAddressId));
    }


    @PostMapping({"/listFreightEstimate"})
    Result<FreightEstimateVO> listFreightEstimate(@RequestBody OrderChildReportParam param) {
        return Result.ok(orderGoodsService.listFreightEstimate(param));
    }

    @ApiOperation(value = "更新挂单运费", notes = "<br>By:艾庆国")
    @PostMapping(value = {"/updatePendingOrderFright"})
    Result<Void> updatePendingOrderFright(@RequestParam("orderGoodsNo") String orderGoodsNo,
                                          @RequestParam("pendingOrderFreight") BigDecimal pendingOrderFreight){

        orderGoodsService.updateFrightPrice(orderGoodsNo, pendingOrderFreight);
        return Result.ok();
    }

    @ApiOperation(value = "定向单绑定车辆", notes = "<br>By:刘海泉")
    @PostMapping({"/saveBindTruck"})
    Result<Object> saveBindTruck(@RequestBody @Validated DistributionTruckParam param) {
        orderGoodsService.saveBindTruck(param);
        return Result.ok();
    }

    @ApiOperation(value = "取消货单", notes = "<br>By:李瑞新")
    @PostMapping({"/cancelOrderGoods"})
    Result<Object> cancelOrderGoods(@RequestBody @Validated CancelOrderGoodsParam param) {
        orderGoodsService.cancelOrderGoods(param);
        return Result.ok();
    }


}
