package com.clx.performance.param.feign;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;


@Getter
@Setter
public class CancelOrderGoodsParam {
    @NotBlank(message = "订单编号不能为空")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @NotNull(message = "操作人编号不能为空")
    @ApiModelProperty("操作人编号")
    private Long createBy;

    @NotNull(message = "操作人名称不能为空")
    @Size(max=32,message = "操作人名称最多输入32个字符")
    @ApiModelProperty("操作人名称")
    private String createName;
}
