package com.clx.performance.enums;

import com.msl.common.enums.ResultEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum PerformanceResultEnum implements ResultEnum {



    /**
     * 系统
     */
    SIGN_NULL(1001, "签名不存在"),
    SIGN_ERROR(1002, "签名错误"),
    TIMESTAMP_ERROR(1003, "请求不在时间范围内"),
    INCREMENT_ERROR(1004, "编码生成失败"),
    HTTP_ERROR(1005, "HTTP请求失败"),
    LOCK_ERROR(1006,"加锁失败"),
    TRY_LOCK_ERROR(1007,"操作频繁,请稍后重试"),
    FEIGN_ERROR(1008, "服务调用失败"),
    /**
     * 通用
     */
    USER_NULL(1101, "用户不存在"),
    MOBILE_NULL(1102, "手机号码未注册"),
    USER_NOT_REGISTER(1103, "用户尚未注册"),
    USER_NOT_AUTH(1104, "用户暂未实名"),
    DATA_NOT_FIND(1105, "数据不存在"),
    DATA_REPEAT(1106, "数据重复"),


    ORDER_GOODS_NO_FOUND(1200, "货单不存在"),
    ORDER_WEIGHT_LACK(1201, "剩余吨数不足，请联系客服"),
    ORDER_INVALID(1202, "无效的货单"),
    ORDER_INVALID1(1203, "当前运单的货源已完成或取消，请查看其他货源"),
    ORDER_DRIVER_LIMIT(1204, "该货单不支持车主抢单"),

    ORDER_CHILD_NO_FOUND(1301, "运单不存在"),
    ORDER_CHILD_STATUS_CHANGED(1302, "运单状态已变更，请重新刷新页面"),
    ORDER_CHILD_CANCELED(1303, "运单状态已取消"),
    ORDER_CHILD_COMPLETE(1304, "运单状态已完成"),
    ORDER_CHILD_OPERATION_FORBID(1305, "没有权限操作"),
    ORDER_CHILD_LOAD_NET_ERROR(1306, "净重不能大于99吨"),
    ORDER_CHILD_TRACE_GT_ROUGH(1306, "皮重不能大于毛重"),

    ORDER_CHILD_SAVE_FAIL(1321, "接单失败,请稍后再试"),
    ORDER_CHILD_SAVE_FREQUENCY_ERROR(1322, "请误频繁点击"),
    ORDER_CHILD_TRUCK_MODEL_ERROR(1323, "请选择合适的车型"),
    ORDER_CHILD_DIRECT_ORDER_TRUCK_ERROR(1324, "请选择定向车辆"),
    ORDER_CHILD_DIRECT_ORDER_TRUCK_ERROR1(1325, "请选择非定向车辆"),
    ORDER_CHILD_DRIVER_TAKE_ORDER_TIME_LIMIT(1326, "你已因违约行为被限制接单，限制时间至"),

    ORDER_CHILD_LOAD_TIME_ERROR(1341, "非装车时间段"),
    ORDER_CHILD_UNLOAD_TIME_ERROR(1342, "非卸车时间段"),
    ORDER_CHILD_ARRIVE_SEND_ADDRESS_DISTANCE_ERROR(1343, "没有到达货源地"),
    ORDER_CHILD_ARRIVE_RECEIVE_ADDRESS_DISTANCE_ERROR(1344, "没有到达目的地"),
    ORDER_CHILD_LOAD_TIMEOUT(1345, "超过最晚到达货源地时间"),
    ORDER_CHILD_LOAD_WEIGHT_ERROR(1346, "装货净重超过载重的1.5倍"),
    ORDER_CHILD_UNLOAD_WEIGHT_ERROR(1347, "卸货净重超过载重的1.5倍"),

    ORDER_CHILD_POUND_AUDIT(1361, "磅单审核中"),
    ORDER_CHILD_POUND_REJECT(1362, "磅单审核驳回，请重新提交信息"),

    ORDER_CHILD_DIRECT_REJECT_TRUCK_ERROR(1381, "非定向车辆无法取消"),
    ORDER_CHILD_CANCEL_FORBID(1382, "运单无法取消"),
    ORDER_CHILD_CANCEL_FORBID_COUNT(1383, "今日取消运单次数超过上限，暂时无法取消"),
    ORDER_GOODS_ID_GENERATE_LOCK(1384, "货单编号ID获取锁出问题"),


    INTEGRAL_TRUCK_DRIVER_EXIST(1400, "车辆已添加"),
    INTEGRAL_ORDER_EXIST(1401, "货单已添加"),
    INTEGRAL_ORDER_NO_EXIST(1402, "货单不存在"),
    INTEGRAL_TRUCK_NO_EXIST(1403, "车辆不存在"),

    ORDER_NO_FOUND(1500, "订单不存在"),

    BREAK_CONTRACT_NO_FOUND(1600, "违约不存在"),
    BREAK_CONTRACT_RULE_NAME_EXIST(1601, "违约规则名称已存在"),
    BREAK_CONTRACT_RULE_NO_FOUND(1602, "违约规则不存在"),
    STATUS_CHANGED(1603, "状态已变更，请重新刷新页面"),
    SETTLEMENT_ORDER_STATUS_CHANGED(1401, "结算单状态已变更，请重新刷新页面"),
    SETTLEMENT_NO_FOUND(1401, "结算单不存在"),
    MONEY_NO_SAME(1501, "货主提现金额和平台支付金额不一致"),
    REJECT_REASON_NULL(1611, "驳回原因不能为空"),
    REJECT_REASON_TOO_LARGE(1612, "驳回原因过长"),

    ORDER_GOODS_WEIGHT_NOT_HAVE(1601, "货单可拉运吨数不足"),
    ORDER_GOODS_STATUS_NOT_GET(1602, "当前货单已关闭不可继续提取"),

    INTEGRAL_RULE_NO_FOUND(1700, "积分规则不存在"),
    INTEGRAL_RULE_RATIO_OVERLAP(1701, "层级划分范围重叠"),
    INTEGRAL_RULE_RATIO_ALL_EMPTY(1702, "层级划分范围不能全为空"),
    INTEGRAL_RULE_NAME_EXIST(1703, "层级名称已存在"),

    APP_POP_UP_ERROR(-1000, "app弹窗提示"),
    /**司机提示语 **/
    APP_POP_UP_DRIVER_RESIDUE_ERROR(-500, "app弹窗提示"),
    /**车主提示语 **/
    APP_POP_UP_OWNER_RESIDUE_ERROR(-499, "app弹窗提示"),
    WALLET_CODE_IS_NULL(1704, "用户钱包不存在"),

    ORDER_GOODS_SAVE_FAIL(1801, "保存货单失败,请稍后再试"),

    USER_ID_IS_EMPTY(1900, "用户ID不能为空"),
    MOBILE_IS_EMPTY(1901, "用户手机号不能为空"),
    CAPTCHA_IS_EMPTY(1902, "验证码不能为空"),
    USER_ACCOUNT_NOT_FOUND(1903, "用户账号未找到"),
    CAPTCHA_IS_EXPIRE(1904, "短信验证码已失效,请重新发送"),
    CAPTCHA_MORE_COUNT(1905, "验证码发送过于频繁,请稍后再发"),
    CAPTCHA_IS_FAIL(1906, "验证码错误"),
    BUSINESS_NO_FAIL(1907, "营业执照校验不一致,请重新输入"),
    TOKEN_IS_FAIL(1908, "token失效,请重新获取token"),
    PASSWORD_RESET_IS_FAIL(1909, "重置密码出现异常"),
    PASSWORD_CHECK_FAIL(1910, "交易密码填写错误,请重新输入"),
    SLIDER_CHECK_FAIL(1911, "滑块验证错误"),

    ORDER_CHILD_SYNC_ERROR(2001, "承运同步网络货运异常"),
    BORROWER_NAME_EXIST(1701, "数据重复，请核实后重新提交"),
    BORROWER_DELETE_ENABLE_ERROR(1702, "无法删除启用数据"),
    BORROWER_CONFIG_BORROWER_ID_EXIST(1703, "数据重复，请核实后重新提交"),
    BORROWER_CONFIG_DELETE_ENABLE_ERROR(1704, "无法删除启用数据"),
    BORROWER_CONFIG_TYPE_NOT_SUPPORT_ERROR(1705, "借款类型不支持"),
    BORROWER_CONFIG_DELETE_ENABLE_STATUS_ERROR(1706, "借款配置已禁用，不允许借款。"),
    BORROWER_DELETE_ENABLE_STATUS_ERROR(1707, "借出方已禁用，不允许借款。"),


    NB_BANK_API_ERROR(1800, "宁波银行api调用失败"),
    NB_BANK_NOTIFY_ERROR(1801, "宁波银行回调失败"),
    NB_BANK_PAY_TYPE_ERROR(1802, "支付方式不支持"),
    NB_BANK_ORDER_PAY_ERROR(1803, "宁波银行订单支付失败"),
    NB_BANK_NO_MONEY_ERROR(1804, "账户余额不足"),
    NB_BANK_PAY_DISABLE_ERROR(1805, "商户未开通相关支付方式"),
    NB_BANK_ACCOUNT_NOT_FOUND_ERROR(1806, "账户信息不存在"),
    NB_BANK_MERCHANT_STATUS_ERROR(1807, "商户信息不存在或商户状态异常"),
    NB_BANK_AMOUNT_OUT_OF_RANGE_ERROR(1807, "明细金额超限"),
    NB_BANK_NAME_BANK_NO_MISSMATCH_ERROR(1808, "账户名称与银行记录不符"),

    PLATFORM_ACCOUNT_CONFIG_ONLY(1913, "当前配置已存在"),
    PLATFORM_ACCOUNT_CONFIG_WITHDRAWAL_IS_NULL(1914, "提现平台账户未配置"),
    PLATFORM_ACCOUNT_CONFIG_WITHDRAWAL_MANY(1915, "提现平台账户配置不唯一"),
    PLATFORM_ACCOUNT_CONFIG_RECHARGE_IS_NULL(1916, "充值平台账户未配置"),
    PLATFORM_ACCOUNT_CONFIG_RECHARGE_MANY(1917, "充值平台账户配置不唯一"),
    PLATFORM_ACCOUNT_CONFIG_IS_NULL(1918, "平台账户未配置"),
    PLATFORM_ACCOUNT_CONFIG_MANY(1919, "平台账户配置不唯一"),
    GET_LOAN_RECORD(1901, "货主借款失败"),
    OWNER_ACCOUNT_ERROR(1902, "货主货款不足"),


    OWNER_LOAN_RECORD_PAY_STATUS_ERROR(1850, "状态已变更无法支付"),
    OWNER_LOAN_RECORD_CANCEL_STATUS_ERROR(1851, "状态已变更无法取消"),
    OWNER_LOAN_RECORD_ADJUST_STATUS_ERROR(1852, "状态已变更无法核销"),
    OWNER_LOAN_RECORD_PAY_WAIT_ERROR(1853,"当前借款单状态不是待付款"),
    OWNER_LOAN_PAYMENT_STATUS_ERROR(1854, "执行借款审批失败,请稍后重试"),
    OWNER_LOAN_PAY_STATUS_ERROR(1855, "付款失败"),
    DATA_STATUS_ERROR(1856, "当前状态有误")

    ;
    private final int code;
    private final String msg;
}
