/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.der.util.DERUtil;
import java.io.UnsupportedEncodingException;

public class CSRParameters {
    private static final String PEROID = "1.3.6.1.4.1.47566.3.100.";
    private String raName;
    private String encoding;
    private String userName;
    private String idType;
    private String userid;
    public static final String CERTTYPE_RSA1024 = "RSA1024";
    public static final String CERTTYPE_RSA2048 = "RSA2048";
    public static final String CERTTYPE_SM2 = "SM2";
    private String certType;
    private String DN;
    private String mobile;
    private String expDate;
    private byte[] plainText;
    private String extvalue;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("raname=").append(this.raName).append("\n");
        buf.append("encoding=").append(this.encoding).append("\n");
        buf.append("userName=").append(this.userName).append("\n");
        buf.append("idType=").append(this.idType).append("\n");
        buf.append("userid=").append(this.userid).append("\n");
        buf.append("certType=").append(this.certType).append("\n");
        buf.append("DN=").append(this.DN).append("\n");
        buf.append("mobile=").append(this.mobile).append("\n");
        buf.append("expDate=").append(this.expDate).append("\n");
        buf.append("extvalue=").append(this.extvalue).append("\n");
        return buf.toString();
    }

    public String getExtValue() {
        return this.extvalue;
    }

    public void setExtValue(String extvalue) {
        this.extvalue = extvalue;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getExpDate() {
        return this.expDate;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setExpDate(String expDate) {
        this.expDate = expDate;
    }

    public byte[] getPlainText() {
        return this.plainText;
    }

    public void setPlainText(byte[] plainText) {
        this.plainText = plainText;
    }

    public String getRaName() {
        return this.raName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getDN() {
        return this.DN;
    }

    public void setRaName(String raName) {
        this.raName = raName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public void setDN(String dN) {
        this.DN = dN;
    }

    public static CSRParameters generateCSRParameter(byte[] csr) throws UnsupportedEncodingException {
        CSRParameters paras = new CSRParameters();
        DERSegment seg = new DERSegment(csr);
        seg = seg.getInnerDERSegment();
        String encoding = null;
        while (seg.hasMoreDERSegment()) {
            DERSegment para = seg.nextDERSegment();
            Object[] paraData = CSRParameters.generatePara(para);
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.1")) {
                paras.setRaName(new String((byte[])paraData[1]));
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.2")) {
                paras.setEncoding(new String((byte[])paraData[1]));
                encoding = paras.getEncoding();
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.3")) {
                if (encoding != null) {
                    paras.setUserName(new String((byte[])paraData[1], encoding));
                } else {
                    paras.setUserName(new String((byte[])paraData[1]));
                }
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.4")) {
                paras.setIdType(new String((byte[])paraData[1]));
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.5")) {
                paras.setUserid(new String((byte[])paraData[1]));
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.6")) {
                paras.setCertType(new String((byte[])paraData[1]));
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.7")) {
                if (encoding != null) {
                    paras.setDN(new String((byte[])paraData[1], encoding));
                } else {
                    paras.setDN(new String((byte[])paraData[1]));
                }
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.8")) {
                paras.setMobile(new String((byte[])paraData[1]));
            }
            if (paraData[0].equals("1.3.6.1.4.1.47566.3.100.9")) {
                paras.setExpDate(new String((byte[])paraData[1]));
            }
            if (!paraData[0].equals("1.3.6.1.4.1.47566.3.100.10")) continue;
            paras.setExtValue(new String((byte[])paraData[1]));
        }
        return paras;
    }

    private static Object[] generatePara(DERSegment paraSeg) {
        Object[] ret = new Object[2];
        paraSeg = paraSeg.getInnerDERSegment();
        DERSegment oid = paraSeg.nextDERSegment();
        ret[0] = DERUtil.ASN12OID(oid.getInnerData());
        DERSegment content = paraSeg.nextDERSegment();
        ret[1] = content.getInnerData();
        return ret;
    }

    public byte[] getEncoded() {
        byte[] para;
        byte[] encoded = new byte[]{};
        if (this.raName != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.1", this.raName);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.encoding != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.2", this.encoding);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.userName != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.3", this.userName);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.idType != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.4", this.idType);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.userid != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.5", this.userid);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.certType != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.6", this.certType);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.DN != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.7", this.DN);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.mobile != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.8", this.mobile);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.expDate != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.9", this.expDate);
            encoded = DERUtil.connect(encoded, para);
        }
        if (this.extvalue != null) {
            para = this.encodeParameter("1.3.6.1.4.1.47566.3.100.10", this.extvalue);
            encoded = DERUtil.connect(encoded, para);
        }
        return DERUtil.generateDERCode(48, encoded);
    }

    private byte[] encodeParameter(String id, String value) {
        byte[] oid = DERUtil.oid2ASN1(id);
        oid = DERUtil.generateDERCode(6, oid);
        byte[] content = DERUtil.generateDERCode(4, value.getBytes());
        byte[] para = DERUtil.connect(oid, content);
        return DERUtil.generateDERCode(48, para);
    }
}

