/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERGeneralizedTime;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.DERUTCTime;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.Time;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.asn1.x509.X509Name;
import java.util.Enumeration;

public class TBSCertList
extends ASN1Encodable {
    ASN1Sequence seq;
    DERInteger version;
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time thisUpdate;
    Time nextUpdate;
    ASN1Sequence revokedCertificates;
    X509Extensions crlExtensions;

    public static TBSCertList getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertList.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertList getInstance(Object obj) {
        if (obj instanceof TBSCertList) {
            return (TBSCertList)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new TBSCertList((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public TBSCertList(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 7) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int seqPos = 0;
        this.seq = seq;
        this.version = seq.getObjectAt(seqPos) instanceof DERInteger ? DERInteger.getInstance(seq.getObjectAt(seqPos++)) : new DERInteger(0);
        this.signature = AlgorithmIdentifier.getInstance(seq.getObjectAt(seqPos++));
        this.issuer = X509Name.getInstance(seq.getObjectAt(seqPos++));
        this.thisUpdate = Time.getInstance(seq.getObjectAt(seqPos++));
        if (seqPos < seq.size() && (seq.getObjectAt(seqPos) instanceof DERUTCTime || seq.getObjectAt(seqPos) instanceof DERGeneralizedTime || seq.getObjectAt(seqPos) instanceof Time)) {
            this.nextUpdate = Time.getInstance(seq.getObjectAt(seqPos++));
        }
        if (seqPos < seq.size() && !(seq.getObjectAt(seqPos) instanceof DERTaggedObject)) {
            this.revokedCertificates = ASN1Sequence.getInstance(seq.getObjectAt(seqPos++));
        }
        if (seqPos < seq.size() && seq.getObjectAt(seqPos) instanceof DERTaggedObject) {
            this.crlExtensions = X509Extensions.getInstance(seq.getObjectAt(seqPos));
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        if (this.revokedCertificates == null) {
            return new CRLEntry[0];
        }
        CRLEntry[] entries = new CRLEntry[this.revokedCertificates.size()];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new CRLEntry(ASN1Sequence.getInstance(this.revokedCertificates.getObjectAt(i)));
            ++i;
        }
        return entries;
    }

    public Enumeration getRevokedCertificateEnumeration() {
        if (this.revokedCertificates == null) {
            return new EmptyEnumeration();
        }
        return new RevokedCertificatesEnumeration(this.revokedCertificates.getObjects());
    }

    public X509Extensions getExtensions() {
        return this.crlExtensions;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }

    public class CRLEntry
    extends ASN1Encodable {
        ASN1Sequence seq;
        DERInteger userCertificate;
        Time revocationDate;
        X509Extensions crlEntryExtensions;

        public CRLEntry(ASN1Sequence seq) {
            if (seq.size() < 2 || seq.size() > 3) {
                throw new IllegalArgumentException("Bad sequence size: " + seq.size());
            }
            this.seq = seq;
            this.userCertificate = DERInteger.getInstance(seq.getObjectAt(0));
            this.revocationDate = Time.getInstance(seq.getObjectAt(1));
        }

        public DERInteger getUserCertificate() {
            return this.userCertificate;
        }

        public Time getRevocationDate() {
            return this.revocationDate;
        }

        public X509Extensions getExtensions() {
            if (this.crlEntryExtensions == null && this.seq.size() == 3) {
                this.crlEntryExtensions = X509Extensions.getInstance(this.seq.getObjectAt(2));
            }
            return this.crlEntryExtensions;
        }

        public DERObject toASN1Object() {
            return this.seq;
        }
    }

    private class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }

    private class RevokedCertificatesEnumeration
    implements Enumeration {
        private final Enumeration en;

        RevokedCertificatesEnumeration(Enumeration en) {
            this.en = en;
        }

        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return new CRLEntry(ASN1Sequence.getInstance(this.en.nextElement()));
        }
    }
}

