package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTrafficCongestionSaveParam;
import com.clx.performance.param.app.collect.PageCollectTraficCongestionParam;
import com.clx.performance.service.collect.CollectTrafficCongestionService;
import com.clx.performance.vo.pc.collect.CollectTrafficCongestionVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/traffic")
@Validated
@Api(tags = "APP-交通上报")
@AllArgsConstructor
public class AppDriverCollectTrafficCongestionController {

    private final CollectTrafficCongestionService collectTrafficCongestionService;

    @ApiOperation(value = "上报交通", notes = "<br>By:艾庆国")
    @PostMapping("/saveTrafficReport")
    public Result<Void> saveTrafficReport(@RequestBody @Validated CollectTrafficCongestionSaveParam param) {
        collectTrafficCongestionService.saveTrafficReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询交通上报详情", notes = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<CollectTrafficCongestionVO> getReportInfo(Integer id) {

        return Result.ok(collectTrafficCongestionService.getReportInfo(id));
    }

    @ApiOperation(value = "分页查询交通上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageTrafficReport")
    @UnitCovert(param = false)
    public Result<PageData<CollectTrafficCongestionVO>> pageTrafficReport(@RequestBody @Validated PageCollectTraficCongestionParam param) {
        IPage<CollectTrafficCongestionVO> page = collectTrafficCongestionService.pageTrafficReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
