package com.clx.performance.sqlProvider.borrower;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.loan.carrier.PageOwnerRepaymentOfOwner;
import com.clx.performance.vo.pc.loan.carrier.OwnerRepaymentVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OwnerRepaymentSqlProvider {

    public String pageByParam(@Param("page") Page<OwnerRepaymentVO> page, @Param("param") PageOwnerRepaymentOfOwner param) {
        return new SQL(){{

            SELECT(" id, owner_user_no as ownerUserNo, owner_user_name as ownerUserName, mobile, " +
                    " running_water_open_no as runningWaterOpenNo, repayment_no as repaymentNo, " +
                    " repayment_balance as repaymentBalance, payment, payment_account as paymentAccount, " +
                    " payee, payee_account as payeeAccount, loan_no as loanNo, status, pay_channel as payChannel, " +
                    " be_overdue as beOverdue, date_format(loan_repayment_time, '%Y-%m-%d %H:%i:%s') as loanRepaymentTime, " +
                    " date_format(operate_time, '%Y-%m-%d %H:%i:%s') as operateTime, operate_by as operateBy,  create_by as createBy, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("owner_repayment");
            WHERE("owner_user_no = #{param.ownerUserNo}");

            if (StringUtils.isNotBlank(param.getRepaymentNo())) {WHERE("repayment_no = #{param.repaymentNo}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}
            if (Objects.nonNull(param.getLoanNo())) {WHERE("loan_no = #{param.loanNo}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}
            if (Objects.nonNull(param.getBeOverdue())) {WHERE("be_overdue = #{param.beOverdue}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
