package com.clx.performance.sqlProvider.borrower;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OwnerLoanAccountSqlProvider {

    public String pageByParam(@Param("page") Page<OwnerLoanAccountVO> page, @Param("param") PageOwnerLoanAccountParam param) {
        return new SQL(){{

            SELECT(" id, owner_user_no as ownerUserNo, owner_user_name as ownerUserName, mobile, " +
                    " account_type as accountType, funding_amount as fundingAmount, virtually_amount as virtuallyAmount, " +
                    " funding_arrears as fundingArrears, virtually_arrears as virtuallyArrears, " +
                    " create_by as createBy, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("owner_loan_account");

            if (Objects.nonNull(param.getOwnerUserNo())) {WHERE("owner_user_no = #{param.ownerUserNo}");}
            if (StringUtils.isNotBlank(param.getOwnerUserName())) {WHERE("owner_user_name = like CONCAT(#{param.ownerUserName},'%')");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
