package com.clx.performance.sqlProvider.borrower;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.enums.StatusEnum;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerParam;
import com.clx.performance.vo.pc.loan.carrier.BorrowerVO;
import com.clx.user.enums.DeleteStatusEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class BorrowerSqlProvider {

    public String pageByParam(@Param("page") Page<BorrowerVO> page, @Param("param") PageBorrowerParam param) {
        return new SQL(){{

            SELECT(" id, name, bank_name as bankName, bank_card_no as bankCardNo, " +
                    " delete_status, status, " +
                    " op_user_no as opUserNo, op_user_name as opUserName, date_format(op_time, '%Y-%m-%d %H:%i:%s') as opTime, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("borrower");
            WHERE("delete_status = 0");

            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = like CONCAT(#{param.name},'%')");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

    public String selectAllBorrowConfig() {
        return new SQL(){{
            SELECT(" a.name,a.bank_card_no as bankCardNo,b.type,b.day ");
            FROM("borrower a");
            WHERE("a.delete_status = " + DeleteStatusEnum.NO.getCode());
            WHERE("a.status = " + StatusEnum.YES.getCode());
            WHERE("b.delete_status = " + DeleteStatusEnum.NO.getCode());
            WHERE("b.status = " + StatusEnum.YES.getCode());
            ORDER_BY("create_time desc");
        }}.toString();
    }



}
