package com.clx.performance.service.impl.thirdparty.nbbank;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.nbbank.NbBankRecordEnum;
import com.clx.performance.service.thirdparty.nbbank.NbBankNotifyService;
import com.clx.performance.service.thirdparty.nbbank.NbBankService;
import com.clx.performance.service.thirdparty.nbbank.NbBankThirdpartyService;
import com.msl.common.exception.ServiceSystemException;
import com.nbopen.api.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Slf4j
@Service
public class NbBankNotifyServiceImpl implements NbBankNotifyService {

    @Autowired
    private NbBankService bankService;

    @Autowired
    private NbBankThirdpartyService nbBankThirdpartyService;

    /**
     * 支付回调
     * 6.2异步通知交易结果
     * 解密后
     * {
     *     "data": {
     *         "clearDate": "20231205",
     *         "merId": "EFT33021200556315",
     *         "merSeqNo": "20231205165038",
     *         "payMethod": "L",
     *         "pyerInfList": [
     *             {
     *                 "coreSeqNo": "",
     *                 "customerId": "",
     *                 "pyerAcctBankName": "",
     *                 "pyerAcctBankNo": "",
     *                 "pyerAcctName": "黑玫瑰",
     *                 "pyerAcctNo": "86041110000076809",
     *                 "signNo": "00",
     *                 "transAmt": "0.01",
     *                 "transDtTm": "2023-12-05 16:54:22"
     *             }
     *         ],
     *         "realTrxAmt": "0.01",
     *         "transDate": "20231205",
     *         "transSeqNo": "2023120516503906838128gg6DOzjP",
     *         "transStatus": "00",
     *         "trxAmt": "0.01"
     *     },
     *     "head": {
     *         "rqsJrnlNo": "16071726224843844",
     *         "rspCode": "000000",
     *         "rspDate": "2023-12-05",
     *         "rspMsg": "处理成功",
     *         "rspTime": "17:13:43:943"
     *     }
     * }
     */
    @Override
    public void payNotify(String body) {
        log.info("宁波银行回调, data:{}", JSON.toJSONString(body));

        try {
            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(JSON.parseObject(body));
            requestApiData.setServiceId("notifyMerchant");

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);
            log.info("宁波银行, 回调:{}", JSON.toJSONString(request));
            SDKResponse response = NBOpenSDK.decryptMessage(request);
            log.info("宁波银行, 回调解密:{}", JSON.toJSONString(response));

            JSONObject responseJson = JSON.parseObject(JSON.toJSONString(response));
            JSONObject data = responseJson.getJSONObject("data");

            nbBankThirdpartyService.recordSave(NbBankRecordEnum.Type.NOTIFY_MERCHANT.getCode(), request, response);

            if (!StringUtils.equals(data.getString("errorCode"), "000000")){
                log.info("宁波银行, 下单失败(notifyMerchant), code:{}, msg:{}", data.getString("errorCode"), data.getString("errorMsg"));
                throw new ServiceSystemException(PerformanceResultEnum.NB_BANK_API_ERROR);
            }

            String merSeqNo = data.getString("merSeqNo");
            String transSeqNo = data.getString("transSeqNo");
            Integer trxAmt = data.getBigDecimal("trxAmt").movePointRight(2).intValue();
            Integer realTrxAmt = data.getBigDecimal("realTrxAmt").movePointRight(2).intValue();
            String transStatus = data.getString("transStatus");
            String signNo = data.getString("signNo");

            // 回调
            bankService.orderPayCallback(merSeqNo, transSeqNo, trxAmt, realTrxAmt, transStatus, signNo);

        }catch (Exception e){
            throw new ServiceSystemException(PerformanceResultEnum.NB_BANK_NOTIFY_ERROR);
        }
    }


}
