package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.CarrierOwnerLoanRecordApproveParam;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerLoanRecordParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanRecordOfOwner;
import com.clx.performance.service.loan.OwnerLoanRecordService;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerLoanRecord")
@Validated
@Api(tags = "承运端-借款管理")
@AllArgsConstructor
public class CarrierOwnerLoanRecordController {

    private final OwnerLoanRecordService ownerLoanRecordService;


    @ApiOperation(value = "借款审批列表",notes = "<br>By:刘海泉")
    @PostMapping("/pageOwnerLoanRecord")
    @UnitCovert(param = false)
    public Result<PageData<OwnerLoanRecordVO>> pageOwnerLoanRecord(@RequestBody @Validated PageCarrierOwnerLoanRecordParam param) {
        IPage<OwnerLoanRecordVO> page  = ownerLoanRecordService.pageOwnerLoanRecord(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "借款审批",notes = "<br>By:胡宇帆")
    @PostMapping("/ownerLoanRecordApprove")
    public Result<Object> ownerLoanRecordApprove(@RequestBody @Validated CarrierOwnerLoanRecordApproveParam param) {
        ownerLoanRecordService.ownerLoanRecordApprove(param);
        return Result.ok();
    }

    @ApiOperation(value = "分页搜索货主借款列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageOwnerLoanRecordOfOwner")
    public Result<PageData<OwnerLoanRecordVO>> pageOwnerLoanRecordOfOwner(@RequestBody @Validated PageOwnerLoanRecordOfOwner param) {
        IPage<OwnerLoanRecordVO> page = ownerLoanRecordService.pageOwnerLoanRecordOfOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
