package com.clx.performance.vo.pc.loan.owner;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName CashierInfoVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:24
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CashierInfoVO {

    @ApiModelProperty("还款单号")
    private Long repaymentNo;

    @ApiModelProperty("货物名称")
    private String goodsName;


    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    @MoneyOutConvert
    @ApiModelProperty("订单金额")
    private BigDecimal repaymentBalance;

    @ApiModelProperty("支付方式")
    private List<Integer> payWay;


    @ApiModelProperty("付款账户")
    private String payAccount;

}
