package com.clx.performance.vo.pc.loan.carrier;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 货主借款账户
* @Date: 2024/01/22 18:17:57
* @Version: 1.0
*/

@ApiModel(description = "货主借款账户")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerLoanAccountVO {

    @ApiModelProperty(value = "货主编码", example = "10000000")
    private Long ownerUserNo;
    @ApiModelProperty(value = "货主名称", example = "张三")
    private String ownerUserName;
    @ApiModelProperty(value = "联系电话", example = "13000000000")
    private String mobile;
    @ApiModelProperty(value = "默认 3：借款账户", example = "3")
    private Integer accountType;


    @ApiModelProperty(value = "账户余额 (元) ", example = "1.23")
    private BigDecimal amount;
    public BigDecimal getAmount() {
        return BigDecimal.ZERO.add(fundingAmount==null? BigDecimal.ZERO : fundingAmount).add(virtuallyAmount==null? BigDecimal.ZERO : virtuallyAmount);
    }

    @ApiModelProperty(value = "欠款金额 (元)", example = "1.23")
    private BigDecimal arrears;
    public BigDecimal getArrears() {
        return BigDecimal.ZERO.add(fundingArrears==null? BigDecimal.ZERO : fundingArrears).add(virtuallyArrears==null? BigDecimal.ZERO : virtuallyArrears);
    }

    @ApiModelProperty(value = "创建人", example = "张三")
    private String createBy;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;

    @JsonIgnore
    @ApiModelProperty(value = "资金金额", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingAmount;
    @JsonIgnore
    @ApiModelProperty(value = "虚拟币金额", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyAmount;
    @JsonIgnore
    @ApiModelProperty(value = "资金欠款", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingArrears;
    @JsonIgnore
    @ApiModelProperty(value = "虚拟币欠款", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyArrears;

}