package com.clx.performance.vo.pc.loan.carrier;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 借出方
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@ApiModel(description = "借出方")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BorrowerVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "借出方", example = "")
    private String name;
    @ApiModelProperty(value = "所属银行", example = "")
    private String bankName;
    @ApiModelProperty(value = "银行账号", example = "")
    private String bankCardNo;
    @ApiModelProperty(value = "状态：1启用 2禁用", example = "")
    private Integer status;
    @ApiModelProperty(value = "操作人编码", example = "")
    private Long opUserNo;
    @ApiModelProperty(value = "操作人", example = "")
    private String opUserName;
    @ApiModelProperty(value = "操作时间", example = "")
    private String opTime;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;

}