package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 积分货单
* @Date: 2023-10-10 09:47:04
* @Version: 1.0
*/

@ApiModel(description = "积分货单")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class IntegralOrderVO {

    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "货单编号", example = "1000000000000")
    private String orderGoodsNo;
    @ApiModelProperty(value = "发货地址id", example = "1")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "北京")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "上海")
    private String receiveAddress;
    @ApiModelProperty(value = "货单类型：1优质单 2普通单 3流水单 4支援单", example = "1")
    private Integer orderType;
    @ApiModelProperty(value = "车辆梯队", example = "1")
    private Integer truckEchelon;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}