package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OwnerLoanAccountRunningWaterRecordEnum {
    ;

    //10：运单核销 20：借款
    @Getter
    @AllArgsConstructor
    public enum RunWaterType {
        APPROVE_WAIT(10, "运单核销"),
        APPROVE_PASS(20, "借款"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerLoanAccountRunningWaterRecordEnum.RunWaterType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(OwnerLoanAccountRunningWaterRecordEnum.RunWaterType::getMsg).orElse(null);
        }
    }

}
