package com.clx.performance.vo.pc.vehiclewarn;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnUserEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
* @Author: aiqinguo
* @Description: 车辆预警通知人员表
* @Date: 2024/04/25 13:24:56
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnUserVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "姓名", example = "张三")
    private String name;
    @Schema(description = "手机", example = "13000000000")
    private String mobile;
    @Schema(description = "通知状态: 0禁用 1开启", example = "1")
    private Integer noticeStatus;
    @Schema(description = "通知状态: 0禁用 1开启", example = "1")
    private String noticeStatusMsg;
    public String getNoticeStatusMsg() {
        return VehicleWarnUserEnum.NoticeStatus.getMsgByCode(noticeStatus);
    }
    @Schema(description = "创建人", example = "")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

    @Schema(description = "订单通知配置列表")
    private List<WarnTypeItem> orderWarnTypeItemList;
    public List<WarnTypeItem> getOrderWarnTypeItemList() {
        List<Integer> warnTypeList = JSON.parseArray(orderWarnTypeJson, Integer.class);

        List<WarnTypeItem> list = new ArrayList<>();

        if(Objects.isNull(warnTypeList)){
            return list;
        }
        for (VehicleWarnConfigEnum.OrderWarnType item : VehicleWarnConfigEnum.OrderWarnType.values()) {
            if (warnTypeList.contains(item.getCode())){
                list.add(new WarnTypeItem(item.getCode(), item.getMsg(), 1));
            }
            else {
                list.add(new WarnTypeItem(item.getCode(), item.getMsg(), 0));
            }
        }
        return list;
    }

    @Schema(description = "运单通知配置列表")
    private List<WarnTypeItem> warnTypeItemList;
    public List<WarnTypeItem> getWarnTypeItemList() {
        List<Integer> warnTypeList = JSON.parseArray(warnTypeJson, Integer.class);

        List<WarnTypeItem> list = new ArrayList<>();
        if(Objects.isNull(warnTypeList)){
            return list;
        }
        for (VehicleWarnConfigEnum.WarnType item : VehicleWarnConfigEnum.WarnType.values()) {
            if (warnTypeList.contains(item.getCode())){
                list.add(new WarnTypeItem(item.getCode(), item.getMsg(), 1));
            }
            else {
                list.add(new WarnTypeItem(item.getCode(), item.getMsg(), 0));
            }
        }
        return list;
    }

    @Schema(description = "线路通知配置列表")
    private List<WarnTypeItem> lineWarnTypeItemList;
    public List<WarnTypeItem> getLineWarnTypeItemList() {
        List<Integer> warnTypeList = JSON.parseArray(lineWarnTypeJson, Integer.class);

        List<WarnTypeItem> list = new ArrayList<>();
        if(Objects.isNull(warnTypeList)){
            return list;
        }
        for (LineWarnConfigEnum.WarnType item : LineWarnConfigEnum.WarnType.values()) {
            if (warnTypeList.contains(item.getCode())){
                list.add(new WarnTypeItem(item.getCode(), item.getMsg(), 1));
            }
            else {
                list.add(new WarnTypeItem(item.getCode(), item.getMsg(), 0));
            }
        }
        return list;
    }

    @JsonIgnore
    @Schema(description = "订单通知配置", example = "", hidden = true)
    private String orderWarnTypeJson;
    @JsonIgnore
    @Schema(description = "预警配置", example = "", hidden = true)
    private String warnTypeJson;
    @JsonIgnore
    @Schema(description = "线路预警配置", example = "", hidden = true)
    private String lineWarnTypeJson;

    @Getter
    @Setter
    @NoArgsConstructor
    public static class WarnTypeItem {
        @Schema(description = "报警类型", example = "1")
        private Integer warnType;
        @Schema(description = "报警类型名称", example = "超时")
        private String warnTypeName;
        @Schema(description = "使能：0禁用 1启用", example = "1")
        private Integer enable;

        public WarnTypeItem(Integer warnType, String warnTypeName, Integer enable) {
            this.warnType = warnType;
            this.warnTypeName = warnTypeName;
            this.enable = enable;
        }
    }

}