package com.clx.performance.vo.pc.vehiclewarn;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 预警日志
* @Date: 2024/04/26 11:21:25
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnLogVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "预警信息id", example = "1")
    private Integer infoId;
    @Schema(description = "类型：1暂停预警 2处理预警", example = "1")
    private Integer type;
    @Schema(description = "运单编号", example = "100000")
    private String childNo;
    @Schema(description = "预警名称", example = "超时")
    private String warnName;
    @Schema(description = "预警时间", example = "")
    private String warnTime;
    @Schema(description = "预警屏蔽范围：1运单 2货单 3无预警", example = "1")
    private Integer warnRang;
    @Schema(description = "预警屏蔽结束时间", example = "")
    private LocalDateTime warnEndTime;
    @Schema(description = "内容", example = "预警处理")
    private String content;
    @Schema(description = "创建人", example = "")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}