package com.clx.performance.vo.pc.trace;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class DriverTraceVO {

    @Schema(description = "经度")
    private BigDecimal longitude;
    @Schema(description = "纬度")
    private BigDecimal latitude;
    @Schema(description = "GPS 时间")
    private String gpsTime;
    @Schema(description = "速度")
    private BigDecimal speed;
    @Schema(description = "停留时长（min）", example = "12.3")
    private BigDecimal stayTime=BigDecimal.ZERO;
    @Schema(description = "停留开始时间")
    private String stayBeginTime;
    @Schema(description = "停留结束时间")
    private String stayEndTime;
    @Schema(description = "车辆状态：1空车 2重车", example = "1")
    private Integer truckStatus;
    @Schema(description = "时间")
    private String createTime;
}
