package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName CarrierPageSettlementOwnerDetailVO
 * @Description
 * @Author kavin
 * @Date 2023/10/16 15:01
 * @Version 1.0
 */
@Getter
@Setter
public class CarrierPageSettlementOwnerDetailVO {

    @Schema(description = "计费明细ID")
    private Integer id;                             
    @Schema(description = "货主编码")
    private Long ownerUserNo;                       
    @Schema(description = "货主姓名")
    private String ownerName;                       
    @Schema(description = "订单编号")
    private String orderNo;
    @Schema(description = "运单编号")
    private String childNo;                         
    @Schema(description = "结算单号")
    private String settlementNo;
    @Schema(description = "发货地址id", example = "")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "")
    private String receiveAddress;
    @Schema(description = "货物id")
    private Integer goodsId;                        
    @Schema(description = "货物名称")
    private String goodsName;                       
    @Schema(description = "实际净重（吨）")
    private BigDecimal weight;                      
    @MoneyOutConvert
    @Schema(description = "平台运费报价")
    private BigDecimal freightPrice;
    @MoneyOutConvert
    @Schema(description = "实际运费金额")
    private BigDecimal freight;
    @Schema(description = "货损吨数（吨）")
    private BigDecimal lossWeight;
    @MoneyOutConvert
    @Schema(description = "货损单价")
    private BigDecimal lossPrice;
    @MoneyOutConvert
    @Schema(description = "货损金额")
    private BigDecimal lossFreight;
    @MoneyOutConvert
    @Schema(description = "预付运费金额")
    private BigDecimal prepayFreight;
    @MoneyOutConvert
    @Schema(description = "结算金额")
    private BigDecimal settlementFreight;
    @MoneyOutConvert
    @Schema(description = "开票金额")
    private BigDecimal invoiceFreight;              
    @Schema(description = "开票标识：1网运单 2普通单")
    private Integer invoiceType;
    @MoneyOutConvert
    @Schema(description = "开票服务费")
    private BigDecimal invoiceServiceFee;
    @Schema(description = "开票服务率")
    private BigDecimal invoiceServiceFeeRate;
    @MoneyOutConvert
    @Schema(description = "借款抵扣金额")
    private BigDecimal loanFreight;
    @Schema(description="结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;
    @Schema(description="开票公司id")
    private Integer invoicingCompanyId;
    @Schema(description="开票公司简称")
    private String invoicingCompanyShorterName;
    @Schema(description="拆单备注")
    private String separateRemark;


    @Schema(description = "创建时间")
    private String createTime;



}
