package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主充值
 *
 * @date : 2023-10-12
 */

@Getter
@Setter
@NoArgsConstructor
public class OwnerTopUpVO {
    /**
     * id
     */
    @Schema(description = "id")
    private Integer id;
    /**
     * 充值编号
     */
    @Schema(description = "充值编号")
    private Long topUpNo;
    /**
     * 货主编码
     */
    @Schema(description = "货主编码")
    private Long ownerUserNo;
    /**
     * 充值类型
     */
    @Schema(description = "充值类型  1:保证金 2：预付运费")
    private Integer accountType;
    /**
     * 充值金额
     */
    @Schema(description = "充值金额")
    @MoneyOutConvert
    private BigDecimal topUpBalance;
    /**
     * 状态
     */
    @Schema(description = "状态 10：待审批 20：审批拒绝 30：审批通过")
    private Integer status;
    /**
     * 打款银行
     */
    @Schema(description = "打款银行")
    private String drawingBank;
    /**
     * 打款银行卡号
     */
    @Schema(description = "打款银行卡号")
    private String drawingBankNumber;
    /**
     * 打款凭证
     */
    @Schema(description = "打款凭证")
    private String drawingProof;
    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private String createTime;
    /**
     * 操作人
     */
    @Schema(description = "操作人")
    private String createBy;
    /**
     * 公司名称
     */
    @Schema(description = "公司名称")
    private String companyName;
    /**
     * 审批时间
     */
    @Schema(description = "审批时间")
    private String approvalTime;
    /**
     * 审批人
     */
    @Schema(description = "审批人")
    private String approvalBy;
    /**
     * 审批拒绝
     */
    @Schema(description = "审批拒绝")
    private String approvalTurnDown;

    @Schema(description = "收款人企业信息")
    private String enterpriseName;

    @Schema(description = "收款人账户账号")
    private String accountNumber;

}
