package com.clx.performance.vo.pc;

import com.clx.performance.enums.OrderGoodsEnum;
import com.clx.performance.enums.SyncPlatformEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@NoArgsConstructor
public class OrderGoodsVO {

    @Schema(description="货单id")
    private Integer id;

    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="货单状态")
    private Integer orderGoodsStatus;

    @Schema(description="提取吨数")
    private BigDecimal extractWeight;

    @Schema(description="剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @Schema(description="已拉运吨数")
    private BigDecimal alreadyTransportWeight;

    @Schema(description="已装车吨数")
    private BigDecimal alreadyLoadWeight;

    @Schema(description="发货地址ID")
    private Integer sendAddressId;

    @Schema(description = "发货地址全称")
    private String sendAddressAll;

    @Schema(description="发货地址简称")
    private String sendAddressShorter;

    @Schema(description="发货地址经度")
    private BigDecimal sendLongitude;

    @Schema(description="发货地址纬度")
    private BigDecimal sendLatitude;

    @Schema(description="收货地址ID")
    private Integer receiveAddressId;

    @Schema(description="收货地址全称")
    private String reveiveAddressAll;

    @Schema(description="收货地址简称")
    private String receiveAddressShorter;

    @Schema(description="收货地址经度")
    private BigDecimal receiveLongitude;

    @Schema(description="收货地址纬度")
    private BigDecimal receiveLatitude;

    @Schema(description="货物ID")
    private Integer goodsId;

    @Schema(description="货物名称")
    private String goodsName;

    @Schema(description="挂单方式  1公开派单  2定向派单  3车队公开派单  4车队定向派单")
    private Integer pendingOrderWay;

    @Schema(description="定向运单失效时间")
    private String directionalExpireTime;

    @Schema(description="最晚到达货源地时间/运单的最晚装货时间")
    private String lastArriveSendTime;

    @Schema(description="挂单时间")
    private String pendingOrderTime;

    @Schema(description="提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @Schema(description="需要车辆/辆")
    private Integer needTruckNum;

    @Schema(description="高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @Schema(description="高级物流经理姓名")
    private String seniorLogisticsManagerName;

    @Schema(description="挂单运费")
    @MoneyOutConvert
    private BigDecimal pendingOrderFreight;

    @Schema(description="创建人用户编号")
    private Long userNo;

    @Schema(description="创建人姓名")
    private String userName;

    @Schema(description="创建时间")
    private String createTime;

    @Schema(description="车辆列表")
    private List<String> truckList;

    @Schema(description="批次号")
    private String batchNumber;

    @Schema(description="'最晚到达目的地时间'")
    private String lastArriveReceiveTime;

    @Schema(description="最晚装货时间")
    private String lastLoadTime;

    @Schema(description="'最晚接单时间'")
    private String lastOrderTime;

    @Schema(description="是否暂停 0：否   1：是")
    private Integer stopFlag;
    @Schema(description="结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;

    @Schema(description="用车方式 1：平台车辆配货 2：自有车辆配货")
    private Integer vehicleUsage;

    @Schema(description="可卸车时间段开始")
    private String unloadBeginTime;

    @Schema(description="可卸车时间段结束")
    private String unloadEndTime;

    @Schema(description="可装车时间段开始")
    private String loadBeginTime;

    @Schema(description="可装车时间段结束")
    private String loadEndTime;

    @Schema(description="平台运费报价税类型：0未税 1含税")
    private Integer platformFreightQuotationTaxType;

    @Schema(description="平台服务费费率%")
    private BigDecimal platformServiceFeeRate;

    @MoneyOutConvert
    @Schema(description="接单保证金（分/车）")
    private BigDecimal deposit;

    @Schema(description="是否支持借款：0:否 1:是")
    private Integer supportLoan;


    @Schema(description="结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @Schema(description="接单保证金 平台服务费费率 弹窗和文案显示 0 不显示  1 显示")
    private Integer goodsOrderDetailShow =  0;

    @Schema(description="已派单数")
    private Integer dispatchedOrders;

    /* 20240730 增加货源地信息 */

    @Schema(description = "货源地现场联系人")
    private String sendContact;

    @Schema(description = "货源地联系人手机号")
    private String sendContactPhone;

    @Schema(description = "发货-是否需要系统排队 0 否  1 是")
    private Integer sendWaitSystem;

    @Schema(description = "发货-是否需要系统排队 描述：  需要 不需要")
    public String getSendWaitSystemMsg() {
        return OrderGoodsEnum.SendWaitSystemMsgEnum.getMsgByCode(sendWaitSystem);
    }

    @Schema(description = "发货-排队系统名称")
    private String sendWaitSystemName;

    @Schema(description = "发货-排队系统形式  1:小程序  2:app")
    private Integer sendWaitMode;

    @Schema(description = "发货-排队系统形式 描述：  微信小程序  app")
    public String getSendWaitModeMsg() {
        return OrderGoodsEnum.SendWaitModeEnum.getMsgByCode(sendWaitMode);
    }


    @Schema(description="当前货单总吨数是否超过总拉运量  1:超过  ")
    private Integer overOrderWeight;

    @Schema(description = "目的地现场联系人")
    private String receiveContact;

    @Schema(description = "目的地联系人手机号")
    private String receiveContactPhone;

    @Schema(description = "收货-是否需要系统排队 0 否  1 是")
    private Integer receiveWaitSystem;

    @Schema(description = "收货-是否需要系统排队 描述：  需要 不需要")
    public String getReceiveWaitSystemMsg() {
        return OrderGoodsEnum.SendWaitSystemMsgEnum.getMsgByCode(receiveWaitSystem);
    }

    @Schema(description = "收货-排队系统名称")
    private String receiveWaitSystemName;

    @Schema(description = "收货-排队系统形式  1:小程序  2:app")
    private Integer receiveWaitMode;

    @Schema(description = "收货-排队系统形式 描述：  微信小程序  app")
    public String getReceiveWaitModeMsg() {
        return OrderGoodsEnum.SendWaitModeEnum.getMsgByCode(receiveWaitMode);
    }

    @Schema(description = "订单来源")
    private Integer orderSource;
    private String orderSourceMsg;
    public String getOrderSourceMsg() {
        return SyncPlatformEnum.Source.getNameByCode(orderSource);
    }

    @Schema(description="已接单车数")
    private Integer alreadyLoadTruckAmount;

    @Schema(description="已拉运车数")
    private Integer alreadyTransportTruckAmount;


    @Schema(description = "贸易商名称")
    private String cooperativeCompaniesName;

}