package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
public class NetworkCaseOutRecordVO {

    private Integer id;

    @Schema(description="提现单号")
    private Long caseOutNo;

    @Schema(description="司机编码")
    private String driverUserNo;

    @Schema(description="司机名称")
    private String driverUserName;

    @Schema(description="联系电话")
    private String mobile;

    @Schema(description="收款人")
    private String payee;

    @Schema(description="开户行")
    private String bank;

    @Schema(description="收款银行账户")
    private String collectionBankCode;

    @Schema(description="状态 10：待平台付款 20：已付款")
    private Integer status;

    @Schema(description="状态简介")
    private String statusMsg;

    @Schema(description="平台")
    private String platform;

    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="运单编号")
    private String childNo;

    @Schema(description="变动金额")
    @MoneyOutConvert
    private BigDecimal alterationBalance;

    @Schema(description="操作人")
    private String createBy;

    @Schema(description="创建时间")
    private String createTime;

    @Schema(description="提现完成时间")
    private String finishTime;

    @Schema(description="修改时间")
    private String modifiedTime;

}
