package com.clx.performance.vo.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 车辆信息上报
* @Date: 2023/11/07 11:11:41
* @Version: 1.0
*/

@Schema(description = "车辆信息上报")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class AppCollectTruckVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "车辆id", example = "")
    private Integer truckId;
    @Schema(description = "车牌", example = "")
    private String truckNo;
    @Schema(description = "卸车类型：1自卸侧翻 2自卸立翻 3非自卸", example = "")
    private Integer unloadType;

    @Schema(description = "车贷状态：0无车贷 1有车贷", example = "")
    private Integer autoLoanStatus;
    @Schema(description = "车贷剩余月份", example = "")
    private Integer autoLoanMonth;
    @Schema(description = "车辆停放位置", example = "")
    private String parkAddress;
    @Schema(description = "拉运方式：1标吨 2超吨 3白天标吨晚上超吨", example = "")
    private Integer overTunageType;
    @Schema(description = "接受距常驻地最远距离（公里）", example = "")
    private Integer distanceUsualPlaceMax;
    @Schema(description = "单次任务接受最远距离（公里）", example = "")
    private Integer distanceLineMax;
    @Schema(description = "接受距货源地最远距离（公里）", example = "")
    private Integer distanceSendAddressMax;
    @Schema(description = "拉运货物意愿：1块煤 2面煤 3煤泥", example = "")
    private String goodsType;

}