package com.clx.performance.param.pc.payment;

import lombok.*;

import java.util.List;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class FreezeUnitDTO {
	/** 冻结序列号 */
	private String freezeNo;
	/** 操作金额(单位分) */
	private Long figure;
	/** 平台信息费用(单位分) */
	private Long fee;
	/** 平台信息费收费方式 1from 2to 3all 默认是2 */
	private Integer feeType;
	/** 返还费用 */
	private Long returnFee;
	/** 操作类型 1撤销 2完成 3修改*/
	private Integer action;
	/** 时间戳(单位毫秒) **/
	private Long timestamp;
	/** 签名使用业务系统私钥签名 不参与签名 **/
	private String signature;
	/** 备注 不参与签名 可空 */
	private String remark;
	/** 消费卡列表 */
	private List<PayCardDTO> cardList;
	/** 分账列表 */
	private List<PayChildDTO> childList;
	/** 流程标志 1线上2线下 */
	private String flag;
	/** 补充标记,结合枚举使用(PatchMarkEnum),确定实际业务含义  */
	private Integer patchMark;
	/** 优惠卷id */
	private Integer userCouponId;
}
