package com.clx.performance.param.pc.owner;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class SavePayeeParam {

    @Schema(description = "结算编号", example = "JS415")
    private String settlementNo;

    @Schema(description = "收款人", example = "收款人")
    private String payee;

    @Schema(description = "收款银行", example = "浙江银行")
    private String payeeBankName;

    @Schema(description = "收款银行卡卡号", example = "62213545878787")
    private String payeeBankCardNo;

    @Schema(description = "付款凭证", example = "/a.png")
    private String paymentImg;

    @Schema(description = "付款银行", example = "浙江银行")
    private String paymentBankName;

    @Schema(description = "付款银行卡卡号", example = "62213545878787")
    private String paymentBankCardNo;

    @Schema(description = "付款金额", example = "123")
    private String paymentAmount;

}
