package com.clx.performance.param.pc.breakcontract.carrier;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageBreakContractOwnerRecordParam extends PageParam {

    @Schema(description = "订单号", example = "1000000000")
    private String orderNo;

    @Schema(description="触发类型：1系统触发 2手动触发")
    private Integer triggerType;

    @Schema(description = "违约方类型：1平台 2货主 3司机", example = "1")
    private Integer breakContractPartyType;

    @Schema(description = "开始时间", example = "")
    private String beginTime;

    @Schema(description = "结束时间", example = "")
    private String endTime;

    @Schema(description="确认状态：0-确认中;1-已经确认;2-已驳回")
    private Integer confirmStatus;
}
