package com.clx.performance.param.pc;

import com.clx.performance.param.app.PositionParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class SettlementInvoiceImageUpdateParam extends PositionParam {

    @Schema(description = "结算id", example = "1")
    @NotNull(message = "结算id不能为空")
    private Integer settlementId;

    @Schema(description = "结算凭证", example = "url")
    @NotBlank(message = "结算凭证不能为空")
    private String invoiceImg;

}
