package com.clx.performance.param.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import jakarta.validation.constraints.NotNull;
import java.util.List;


@Getter
@Setter
public class OrderGoodsCancelParam {

    @Schema(description="订单编号")
    private String orderNo;

    @NotNull(message = "货单编号不能为空")
    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="货单取消类型 1：弹窗1  2：取消未接单及未到达货源地的车辆 3：取消未接单及未装车的车辆")
    private Integer cancelOperateType;

    @Schema(description="取消的车辆列表")
    private List<String> truckList;

    @Schema(description="取消原因")
    private String cancelReason;
}
