package com.clx.performance.param.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @ClassName DealExceptionReportParam
 * @Description
 * @Author kavin
 * @Date 2024/10/22 20:07
 * @Version 1.0
 */

@Getter
@Setter
public class DealExceptionReportParam {

    @NotNull(message = "异常上报ID不能为空")
    @Schema(description="异常上报ID")
    private Integer id;


    @NotNull(message = "处理方式不能为空")
    @Schema(description="处理方式  1:同意扣罚  2：申诉" ,example = "枚举 ExceptionReportEnum.DealWay ")
    private Integer dealWay;


    @Schema(description="申诉原因")
    private String appealReason;


    @Schema(description="图片")
    private List<String> pictureUrl;


    @Schema(description="视频")
    private List<String> videoUrl;
}
