package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerSettlementSyncParam {

    @Schema(description = "货主手机")
    @NotBlank(message = "货主手机不能为空")
    private String ownerMobile;

    @Schema(description = "结算单列表")
    @Valid
    @NotEmpty(message = "结算单列表不能空")
    private List<SettlementItem> settlementList;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class SettlementItem{
        @Schema(description = "运单编号列表")
        @NotEmpty(message = "运单编号不能空")
        private String childNo;

        @Schema(description = "结算单编号")
        @NotEmpty(message = "结算单编号不能空")
        private String settlementNo;

    }
}
